<?php

/*
Author: Fiona Coulter
Author URI: https://spiralscripts.co.uk
License: GPL v2
*/


if(! defined('SPIRALFACTCHECKLINKS'))
{
	exit();
}


?>
<div>
  <h2>Fact Check by Spiral Scripts </h2>
  <p> If you have a web page that reviews a claim made by others, you can include a ClaimReview structured data element on your web page. This element enables Google Search results to show a summarized version of your fact check when your page appears in search results for that claim. Find out more <a href="https://developers.google.com/search/docs/data-types/factcheck">here</a>.</p>
  <p>This Fact Check plugin makes that easy to do with Wordpress, by creating a custom post type that includes all the data fields that you will need, and automatically generating the structured data that Google requires.</p>
  <p>In order to be accepted as a fact checker by Google you will need to be a member of the International Fact Checking Network, see <a href="https://www.poynter.org/international-fact-checking-network-fact-checkers-code-principles">https://www.poynter.org/international-fact-checking-network-fact-checkers-code-principles</a> </p>
<h2>User Guide</h2>
  <h4> Settings</h4>
  <p>You can set the name of your organization and your organization URL on the settings page, if your leave these blank then your site name and site URL will be used.</p>
  <h4>Creating Fact Checks</h4>
  <p>Fact checks are created as Wordpress custom post types. To create one, use the 'add new' link. Create your main text and title as for a normal post. You will need to supply additional details about the claim being reviewed in the &quot;Fact Check Details&quot; box. Supply these as follows_</p>
  <dl>
    <dt>Claim Reviewed</dt><dd>the claim being reviewed, eg "the Earth is Flat". You can leave this item blank, then the post title will be used instead.</dd>
    <dt>Claim Author</dt><dd>ie the author of the claim being reviewed, eg the Square Earth Society</dd>
    <dt>Claim Rating</dt><dd>Summary of the evaluation the claim. It is essential to provide this. If the claim is impossible to categorize as true or false, use "Hard to Categorize"</dd>
    <dt>URLs</dt><dd>Provide one or more URLs where the claim is being repeated</dd>   
  </dl>
  <p>Save your post. There is no more that you need to do, the structured data which Google can read will be generated automatically as part of your page source. To view it, you can view the post and right-click on the page, as select &quot;View Source&quot;. Then use &lt;control&gt; F to search for &quot;structured&quot;, you will see it. If you want to test it you can use Google's structured data testing tool here: <a href="https://search.google.com/structured-data/testing-tool">https://search.google.com/structured-data/testing-tool</a></p>
  <p>Copy and paste the structured data into the testing tool as a code snippet. If you encounter any errors (you should not) please report them to us in our support forum.</p>
  <p>&nbsp;  </p>
  <h2>Support</h2>
  <p> If you get stuck, or have any questions, you can ask for help in the Spiral Scripts Support Forum: <a href="https://www.spiralscripts.co.uk/support/forum/fact-checker-plugin.html">https://www.spiralscripts.co.uk/support/forum/fact-checker-plugin.html</a> </p>
</div>