<?php get_header(); 
global $post;
$portfolio_layout = get_post_meta( $post->ID, 'pixomi_portfolio_layout', true );
if($portfolio_layout == 'default'){
	$portfolio_layout_class = 'col-xs-12'; }
elseif($portfolio_layout == 'right-sidebar'){
	$portfolio_layout_class = 'right-sidebar col-lg-9 col-md-9 col-sm-12'; }
elseif($portfolio_layout == 'left-sidebar'){
	$portfolio_layout_class = 'left-sidebar col-lg-9 col-md-9 col-sm-12'; }
else{ $portfolio_layout_class = 'col-xs-12'; } 

// FullWidth Class
if($portfolio_layout == 'fullwidth'){
	$portfolio_fullwidth_class = 'fullwidth';
} else{ $portfolio_fullwidth_class = 'portfolio-single'; }
get_template_part( 'functions/titlebar' ); ?>
<div id="main-content" class="<?php echo esc_attr( $portfolio_fullwidth_class ); ?>">
	<div class="container">
		<div class="row">
			<div class="<?php echo esc_attr( $portfolio_layout_class ); ?>">
				<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<div class="entry-content">
							<?php the_content(); ?>
						</div>
					</article>
				<?php endwhile; endif; ?>
			</div>
			<?php if($portfolio_layout == 'right-sidebar' || $portfolio_layout == 'left-sidebar' ){ ?>
				<div id="sidebar" class="col-lg-3 col-md-3 col-sm-12" role="complementary">
	                <?php get_sidebar(); ?>
	            </div>
			<?php } ?>
		</div>
	</div>
</div>
<div id="portfolio-navigation">
	<?php previous_post_link('%link', '<div class="prev"></div>', FALSE); ?>
	<?php next_post_link('%link', '<div class="next"></div>', FALSE); ?>
</div>
<?php get_footer(); ?>