<?php get_header(); ?>
<div id="main-content" class="search-page">
	<div class="container">
		<div class="row">
			<div class="right-sidebar col-lg-9 col-md-9 col-sm-12 col-xs-12">
				<div class="search-header">
					<h3><?php esc_html_e( 'Need a New Search?', 'pixomi' ); ?></h3>
					<?php get_search_form(); ?>
				</div>				
				<div class="divider"></div>
				<div class="search-content">
					<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
						<article id="post-<?php the_ID(); ?>" <?php post_class('post'); ?>>
							<div class="entry-icon"><i class="fa fa-align-left"></i></div>
							<div class="entry-wrapper">
							    <?php if ( has_post_thumbnail() ) { ?>
							        <div class="entry-image">
							            <a class="entry-overlay" href="<?php the_permalink(); ?>" rel="bookmark" ><?php the_post_thumbnail('pixomi-classic-blog'); ?></a>
							        </div>
							    <?php } ?>
						        <div class="entry-title">
						            <h4><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h4>
						        </div>
						        <div class="entry-type">
							        <?php if( get_post_type($post->ID) == 'post' ){ ?>
							        	<p><?php echo wp_kses_post(pixomi_custom_excerpt(30)); ?></p>
							        <?php } elseif( get_post_type($post->ID) == 'page' ){ ?>
							        	<span><?php echo esc_html__('Page', 'pixomi'); ?></span>
							        <?php } elseif( get_post_type($post->ID) == 'projects' ){ ?>
							        	<span><?php echo esc_html__('Portfolio', 'pixomi'); ?></span>
							        <?php } elseif( get_post_type($post->ID) == 'product' ){ ?>
							        	<span><?php echo esc_html__('Product', 'pixomi'); ?></span>
							        <?php } ?>
						        </div>
							</div>
						</article>
					<?php endwhile; ?>
					<?php pixomi_pagination(); ?>
					<?php else : ?>
						<h2><?php esc_html_e('Nothing Found!', 'pixomi') ?></h2>
					<?php endif; ?>
				</div>
			</div>
            <div id="sidebar" class="col-lg-3 col-md-3 col-sm-12" role="complementary">
                <?php get_sidebar(); ?>
            </div>
		</div>
	</div>
</div>

<?php get_footer(); ?>
