<?php get_header(); 
global $post;
$page_layout = get_post_meta( $post->ID, 'pixomi_page_layout', true );
if($page_layout == 'default'){
	$page_layout_class = 'col-xs-12'; }
elseif($page_layout == 'right-sidebar'){
	$page_layout_class = 'right-sidebar col-lg-9 col-md-9 col-sm-12'; }
elseif($page_layout == 'left-sidebar'){
	$page_layout_class = 'left-sidebar col-lg-9 col-md-9 col-sm-12';
} else{ $page_layout_class = 'col-xs-12'; }

// FullWidth Class
if($page_layout == 'fullwidth'){
	$page_fullwidth_class = 'fullwidth';
} else{ $page_fullwidth_class = ''; } 
pixomi_page_banner(); 
get_template_part( 'functions/titlebar' ); ?> 
<div id="main-content" class="<?php echo esc_attr( $page_fullwidth_class ); ?>">
	<div class="container">
		<div class="row">
			<div class="<?php echo esc_attr( $page_layout_class ); ?>">
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<?php while ( have_posts() ) : the_post(); ?>
						<?php the_content(); ?>
			            <?php wp_link_pages( array(
			                'before'      => '<div class="page-links">' . esc_html__( 'Pages&nbsp;:', 'pixomi' ),
			                'after'       => '</div>',
			                'link_before' => '<span class="page-number">',
			                'link_after'  => '</span>',
			            ) ); ?>
						<?php if ( comments_open() || get_comments_number() ) { comments_template(); } ?>
					<?php endwhile; ?>
				</article>
			</div>
			<?php if($page_layout == 'right-sidebar' || $page_layout == 'left-sidebar' ){ ?>
				<div id="sidebar" class="col-lg-3 col-md-3 col-sm-12" role="complementary">
					<?php get_sidebar(); ?>
				</div>
			<?php } ?>		
		</div>
	</div>
</div>
<?php get_footer(); ?>
