<?php global $post, $pixomi_data; ?>
<?php $blog_style = $pixomi_data['blog_style']; ?>
<article id="post-<?php the_ID(); ?>" <?php post_class('clearfix'); ?>>
    <?php if (is_sticky()) : echo '<div class="sticky-lable"></div>'; endif; ?>
    <?php if ( has_post_thumbnail() ) { ?>
        <div class="entry-image">
            <?php if(!is_single()) { ?>
                <?php if($blog_style == 'classic' ) { ?>
                    <a href="<?php the_permalink(); ?>" rel="bookmark" ><?php the_post_thumbnail('pixomi-classic-blog'); ?></a>
                <?php } else { ?>
                    <a href="<?php the_permalink(); ?>" rel="bookmark" ><?php the_post_thumbnail('pixomi-list-blog'); ?></a>
                <?php } ?>
            <?php } else { ?>
                <?php the_post_thumbnail('pixomi-classic-blog'); ?>
            <?php } ?>
        </div>
    <?php } ?>
    <div class="entry-wrapper">
        <div class="entry-title">
            <?php if(!is_single()){ ?> 
                <h2 class="post-title"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h2>
            <?php } else { ?>
                <h2 class="post-title"><?php the_title(); ?></h2>
            <?php } ?>
        </div>
        <div class="entry-meta">
            <ul>
                <li class="date"><i class="droplet-calendar"></i><?php the_time(get_option('date_format')); ?></li>
                <li class="author"><i class="droplet-user-male"></i><a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta( 'ID' ))); ?>" title="<?php esc_html_e('View all posts by', 'pixomi'); ?> <?php the_author(); ?>"><?php the_author(); ?></a></li>
                <?php if ( comments_open() ) : ?>
                <li class="comment"><i class="droplet-comment-square"></i><?php comments_popup_link( esc_html__('No Comments', 'pixomi'), esc_html__('1 Comment', 'pixomi'), esc_html__('% Comments', 'pixomi'), 'comments-link', 'pixomi'); ?></li>
                <?php endif; ?>
                <li class="category"><i class="droplet-layers"></i><?php the_category(', '); ?></li>                
            </ul>
        </div>
        <div class="entry-content">
            <?php if(!is_single()){ ?>
                    <p><?php echo wp_kses_post(pixomi_custom_excerpt(23)); ?></p>
            <?php } else { ?>
                    <?php the_content(); ?>
            <?php } ?>
            <?php wp_link_pages( array(
                'before'      => '<div class="page-links">' . esc_html__( 'Pages&nbsp;:', 'pixomi' ),
                'after'       => '</div>',
                'link_before' => '<span class="page-number">',
                'link_after'  => '</span>',
            ) ); ?>
        </div>
    </div>
</article>