<?php
/* =========================================================== */
/* 00. Call To Action
/* =========================================================== */
if (!function_exists('pixomi_callout_shortcode')) {
	function pixomi_callout_shortcode( $atts, $content = null) {
		extract( shortcode_atts( array(
			'style' => '1',
			'title' => '',
			'subtitle' => '',
			'cta_title_color' => '',
			'cta_desc_color' => '',
			'cta_bg_color' => '',
			'cta_bg_img' => '',
			'btn_txt' => '',
			'btn_link' => '',
			'btn_target'  => '_self',
			'btn_bg_color' => '',
			'btn_txt_color' => '',
			'btn_radius' => '',
		), $atts ) );
		
		// Bg Img
		$bg_img_src = '';
		if($cta_bg_img != ''){
			$img_src = wp_get_attachment_image_src($cta_bg_img, 'full');
			$bg_img_src .= 'background-image: url('.esc_url($img_src[0]).');';
		} else{
			$bg_img_src .= ' ';
		}

		// Cta Style
		if($style == '1'){
			$cta_style_class = 'cta-style-1';
		}elseif($style == '2'){
			$cta_style_class = 'cta-style-2';
		}else {
			$cta_style_class = 'cta-style-1';
		}

        $out = '<div class="cta ' .esc_attr($cta_style_class). '" style="background-color:'.esc_attr($cta_bg_color).'; '. esc_attr($bg_img_src) . '">
					<div class="container">
						<div class="row">
							<div class="col-md-12">
								<div class="cta-wrapper">
									<div class="cta-content">
										<h1 style="color:'.esc_attr($cta_title_color).';">' . $title . '</h1>
										<p style="color:'.esc_attr($cta_desc_color).';">' . $subtitle . '</p>
									</div>
									<div class="cta-buttons">
									    <a href="' .esc_url($btn_link). '" class="btn" target="' . esc_attr($btn_target) . '" style="background-color:'.esc_attr($btn_bg_color).'; color:'.esc_attr($btn_txt_color).'; border-radius:'.esc_attr($btn_radius).';">' .esc_html($btn_txt). '</a>
									</div>
								</div>
							</div>
						</div>
					</div>
        		</div>';			

		return $out;
	}

	add_shortcode('pixomi_callout', 'pixomi_callout_shortcode');
}

/* =========================================================== */
/* 00. Recent Posts
/* =========================================================== */
if (!function_exists('pixomi_recent_posts_shortcode')) {
	function pixomi_recent_posts_shortcode($atts){
		extract(shortcode_atts(array(
			'posts'      => '4',
			'categories' => 'all',
		), $atts));
		
		global $post;

		// Arg
		$args = array(
			'post_type' => 'post',
			'posts_per_page' => $posts,
			'order'          => 'DESC',
			'orderby'        => 'date',
			'post_status'    => 'publish'
		);
		
		// Category
		if($categories != 'all'){
			$str = $categories;
			$arr = explode(',', $str); 

			$args['tax_query'][] = array(
				'taxonomy'  => 'category',
				'field'   => 'slug',
				'terms'   => $arr
			);
		}

		$wp_query = new WP_Query($args);

		$out = '';

		if( $wp_query->have_posts() ) :

			$out .= '<div class="recent-posts">';  
		
			while ( $wp_query->have_posts() ) : $wp_query->the_post();
		  
		  		$blog_thumbnail= wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'pixomi-classic-blog' );

		  		$out .= '<div class="recent-post">';

			  		if($blog_thumbnail[0] != ''){		  
			  			$out .= '<a class="entry-overlay" href="'. esc_url(get_permalink()) .'" title="'.esc_attr(get_the_title()).'"><img src="'.esc_url($blog_thumbnail[0]).'" alt="' . esc_attr(get_the_title()) . '" /></a>';
					 }

			  		$out .= '<div class="recent-posts-content">
								<h4><a href="'.esc_url(get_permalink()).'">'.esc_html(get_the_title()) .'</a></h4>
					  			<p>'. wp_kses_post(pixomi_custom_excerpt(15)) .'</p>
					  		</div>';

			  		$out .= '<div class="recent-posts-meta">
								<span class="meta"><i class="droplet-calendar"></i>'.esc_attr(get_the_date()).' &nbsp;<strong>By</strong> : '.get_the_author_meta('display_name').'</span>
					  		</div>';

				$out .= '</div>';
		  
			endwhile;

			$out .='</div>';
				
		 	wp_reset_postdata();
	  
		endif;

		return $out;
	}
	add_shortcode('pixomi_recent_posts', 'pixomi_recent_posts_shortcode');
}

/* =========================================================== */
/* 00. Iconboxes 
/* =========================================================== */
if (!function_exists('pixomi_iconboxes_shortcode')) {
	function pixomi_iconboxes_shortcode( $atts, $content = null ) {
		extract(shortcode_atts(array(
			'style'			=> '1',
			'icon'      	=> 'fa-cog',
			'iconimg'		=> '',
			'title'			=> '',
			'btn_txt'       => '',
			'btn_link'      => '',
			'target'        => '_self',
			'icon_color'	=> '',
			'icon_bg_color'	=> '',
			'title_color'   => '',
			'desc_color'     => '',
			'iconbox3_bg_color'=> '',
			'btn_bg_color'  => '',
			'class'			=> ''
		), $atts));

		// Icon or Icon Image
		if($iconimg == ''){
			$symbol = '<i style="color:'.esc_attr($icon_color).'; background-color:'.esc_attr($icon_bg_color).';" class="fa '. esc_attr($icon) .' "></i>';
		}
		else{
			$img_src = wp_get_attachment_image_src($iconimg, 'full');
			$img_alt = get_post_meta($iconimg , '_wp_attachment_image_alt', true);
			$symbol = '<div class="img"><img src="'.esc_url($img_src[0]).'" alt="' .esc_attr($img_alt). '"></div>';
		}

		// Btn
		if($btn_txt != '') {
			$iconbox_btn_src = '<div class="iconbox-btn"><a style="background-color:'.esc_attr($btn_bg_color).';" href='.esc_url($btn_link).' target='. esc_attr($target) .'>'. esc_html($btn_txt) .'</a></div>';
		} else{ $iconbox_btn_src = ''; }

		if($style == '1') {
			$out = '<div class="iconbox '.esc_attr($class).' iconbox-style-'.esc_attr($style).'">
						'.$symbol.'
						<div class="iconbox-content">
							<h3 style="color:'.esc_attr($title_color).';">'. esc_html($title) .'</h3>
							<p style="color:'.esc_attr($desc_color).';">'. do_shortcode($content) . '</p>
                        	' .$iconbox_btn_src. '                        
						</div>
					</div>';
		}elseif($style == '2') {
			$out = '<div class="iconbox '.esc_attr($class).' iconbox-style-'.esc_attr($style).'">
						'.$symbol.'
							<div class="iconbox-content">
								<h3 style="color:'.esc_attr($title_color).';">'. esc_html($title) .'</h3>
								<p style="color:'.esc_attr($desc_color).';">'. do_shortcode($content) . '</p>
                        		' .$iconbox_btn_src. '                        
							</div>
					</div>';
		}elseif($style == '3') {
			$out = '<div class="iconbox '.esc_attr($class).' iconbox-style-'.esc_attr($style).'" style="background-color:'.esc_attr($iconbox3_bg_color).';">
						'.$symbol.'
							<div class="iconbox-content">
								<h3 style="color:'.esc_attr($title_color).';">'. esc_html($title) .'</h3>
								<p style="color:'.esc_attr($desc_color).';">'. do_shortcode($content) . '</p>
                        		' .$iconbox_btn_src. '                        
							</div>
					</div>';
		}else{ $out = ''; }
		return $out;
	}
	add_shortcode('pixomi_iconboxes', 'pixomi_iconboxes_shortcode');
}

/* =========================================================== */
/* 00. Image Box
/* =========================================================== */
if (!function_exists('pixomi_imagebox_shortcode')) {
	function pixomi_imagebox_shortcode( $atts, $content = null) {
		extract( shortcode_atts( array(
			'style' => '1',
			'img' => '',
			'title' => '',
			'btn_txt' => '',
			'btn_link' => '',
			'target'   => '_self',
			'title_color' => '',
			'desc_color' => '',
			'btn_bg_color' => '',
		), $atts ) );

		// Style Class
		$imgbox_style_class = '';
		if($style == '1'){
			$imgbox_style_class = 'imgbox-style-1';
		}
		elseif($style == '2'){
			$imgbox_style_class = 'imgbox-style-2';
		}

		// Btn
		if($btn_txt != '') {
			$imgbox_btn_src = '<div class="imgbox-btn text-center"><a style="background-color:'.esc_attr($btn_bg_color).';" href='.esc_url($btn_link).' target='. esc_attr($target) .'>'. esc_html($btn_txt) .'</a></div>';
		} else{
			$imgbox_btn_src = ''; 
		}

		// Image
		if(!empty($img)) {
			$img_src = wp_get_attachment_image_src($img, 'full');
			$alt_text = get_post_meta($img , '_wp_attachment_image_alt', true);
			$img_output = '<div class="img"><img src="'.esc_url($img_src[0]).'" alt="'.esc_attr($alt_text).'" /></div>';
		} else{
			$img_output = "";
		}
		 
    	return '<div class="' .esc_attr($imgbox_style_class). '">' .$img_output. '
                    <div class="imgbox-content">
                        <div class="imgbox-caption">
                            <h3 style="color:'.esc_attr($title_color).';">'. esc_html($title) .'</h3>
                            <p style="color:'.esc_attr($desc_color).';">'. do_shortcode($content) .'</p>
                        </div>
                        ' .$imgbox_btn_src. '                        
                    </div>
                </div>';			

	}

	add_shortcode('pixomi_imagebox', 'pixomi_imagebox_shortcode');
}

/* =========================================================== */
/* 00. Counter
/* =========================================================== */
if (!function_exists('pixomi_counter_shortcode')) {
	function pixomi_counter_shortcode( $atts ) {
		extract(shortcode_atts(array(
			'number' => '999',
			'title'  => '',
			'number_color' => '',
			'title_color' => '',
		), $atts));
		
		return '<div class="counter">
                	<h2 style="color:'.esc_attr($number_color).';" class="count">' .esc_html($number). '</h2>
                	<h4 style="color:'.esc_attr($title_color).';">' .esc_html($title). '</h4>
                </div>';
	}
	add_shortcode('pixomi_counter', 'pixomi_counter_shortcode');
}

/* =========================================================== */
/* 00. Testimonials Slider 
/* =========================================================== */
if (!function_exists('pixomi_testimonial_slider_shortocde')) {
	function pixomi_testimonial_slider_shortocde( $atts, $content = null) {
		extract( shortcode_atts( array(

			'slide_1_img' => '',
			'slide_1_client' => '',
			'slide_1_info' => '',
			'slide_1_content' => '',
			
			'slide_2_img' => '',
			'slide_2_client' => '',
			'slide_2_info' => '',
			'slide_2_content' => '',
			
			'slide_3_img' => '',
			'slide_3_client' => '',
			'slide_3_info' => '',
			'slide_3_content' => '',
			
			'title_color' => '',
			'role_color' => '',
			'testimonial_color' => '',

		), $atts ) );

		// Slide 1 Image
		if(!empty($slide_1_img)) {
			$slider_1_img_src = wp_get_attachment_image_src($slide_1_img, 'full');
		} else{ $slider_1_img_src = ""; }

		// Slide 2 Image
		if(!empty($slide_2_img)) {
			$slider_2_img_src = wp_get_attachment_image_src($slide_2_img, 'full');
		} else{ $slider_2_img_src = ""; }

		// Slide 3 Image
		if(!empty($slide_3_img)) {
			$slider_3_img_src = wp_get_attachment_image_src($slide_3_img, 'full');
		} else{ $slider_3_img_src = ""; }

		$out = '';
		$out .= '<div class="slick-slider testimonial-slider">';
			
		if($slide_1_content != ''){ $out .= '<div class="testimonial"><img src="' . esc_url($slider_1_img_src[0]) . '" alt="'. esc_attr($slide_1_client) .'"><h4 style="color:'.esc_attr($title_color).';">' .esc_html($slide_1_client). '</h4><span style="color:'.esc_attr($role_color).';">' .esc_html($slide_1_info). '</span><p style="color:'.esc_attr($testimonial_color).';">' .esc_html($slide_1_content). '</p></div>'; }
		if($slide_2_content != ''){ $out .= '<div class="testimonial"><img src="' . esc_url($slider_2_img_src[0]) . '" alt="'. esc_attr($slide_2_client) .'"><h4 style="color:'.esc_attr($title_color).';">' .esc_html($slide_2_client). '</h4><span style="color:'.esc_attr($role_color).';">' .esc_html($slide_2_info). '</span><p style="color:'.esc_attr($testimonial_color).';">' .esc_html($slide_2_content). '</p></div>'; }
		if($slide_3_content != ''){ $out .= '<div class="testimonial"><img src="' . esc_url($slider_3_img_src[0]) . '" alt="'. esc_attr($slide_3_client) .'"><h4 style="color:'.esc_attr($title_color).';">' .esc_html($slide_3_client). '</h4><span style="color:'.esc_attr($role_color).';">' .esc_html($slide_3_info). '</span><p style="color:'.esc_attr($testimonial_color).';">' .esc_html($slide_3_content). '</p></div>'; }

		$out .= '</div>';

		return $out;
	}
	add_shortcode('pixomi_testimonial_slider', 'pixomi_testimonial_slider_shortocde');
}

/* =========================================================== */
/* 00. Testimonial Box 
/* =========================================================== */
if (!function_exists('pixomi_testimonial_boxes_shortcode')) {
	function pixomi_testimonial_boxes_shortcode( $atts, $content = null) {
		extract( shortcode_atts( array(
			'client_img' => '',
			'client_name' => '',
			'client_info' => '',
			'client_content' => '',
			'bg_color' => '',
			'text_color' => '',
			'title_color' => '',
			'role_color' => '',
			'icon_color' => '',
		), $atts ) );

		// Client Image
		if(!empty($client_img)) {
			$client_img_src = wp_get_attachment_image_src($client_img, 'full');
		} else{ $client_img_src = ""; }

		return '<div class="testimonial-box" style="background-color:'.esc_attr($bg_color).';"><i style="color:'.esc_attr($icon_color).';" class="fa fa-quote-left"></i><div class="box-img"><img src="' . esc_url($client_img_src[0]) . '" alt="' .esc_html($client_name). '"></div><p style="color:'.esc_attr($text_color).';">' .esc_html($client_content). '</p><h4 style="color:'.esc_attr($title_color).';">' .esc_html($client_name). '</h4><span style="color:'.esc_attr($role_color).';">' .esc_html($client_info). '</span></div>';		
	}
	add_shortcode('pixomi_testimonial_boxes', 'pixomi_testimonial_boxes_shortcode');
}

/* =========================================================== */
/* 00. Special Heading
/* =========================================================== */
if (!function_exists('pixomi_special_heading_shortcode')) {
	function pixomi_special_heading_shortcode( $atts, $content = null) {
		extract( shortcode_atts( array(
			'heading'  => '',
			'subheading'  => '',
			'switch_sep'  => 'yes',
			'heading_size'	 => '',
			'subheading_size' => '',
			'heading_weight' => '',
			'line_height' => '',			
			'align'	 => 'center',
			'transform'	=> 'none',
			'margin' => '',
			'heading_color'	 => '',
			'subheading_color' => '',
			'sep_color' => '',
		), $atts ) );

		// Seperator Align
		$align_class = '';
		if($align == 'center'){
			$align_class = 'center-sep';
		}elseif($align == 'left'){
			$align_class = 'left-sep';
		}elseif($align == 'right'){
			$align_class = 'right-sep';
		}else {
			$align_class = 'center-sep';
		}

		// Seperator
		$switch_sep_src = '';
		if($switch_sep == 'yes'){
			$switch_sep_src = '<div style="background-color:'.esc_attr($sep_color).'; text-align:'.esc_attr($align).';" class="heading-seperator '. esc_attr($align_class) .'"></div>';
		}else{
			$switch_sep_src ='';
		}

		return '<div style="margin:'.esc_html($margin).';" class="special-heading">
					<h1 style="font-size:'.esc_html($heading_size).'; font-weight:'.esc_html($heading_weight).'; line-height:'.esc_html($line_height).'; text-align:'.esc_attr($align).'; text-transform:'.esc_attr($transform).'; color:'.esc_attr($heading_color).';">' . $heading . '</h1>
					'.$switch_sep_src.'
					<p style="font-size:'.esc_html($subheading_size).'; text-align:'.esc_attr($align).'; color:'.esc_attr($subheading_color).';">' . $subheading . '</p>
				</div>';

	}
	add_shortcode('pixomi_special_heading', 'pixomi_special_heading_shortcode');
}

/* =========================================================== */
/* 00. List 
/* =========================================================== */
if (!function_exists('pixomi_list_shortcode')) {
	function pixomi_list_shortcode( $atts, $content = null) {
		extract( shortcode_atts( array(
		), $atts ) );

		return '<div class="list-shortcode">'. do_shortcode($content) . '</div>';		
	}
	add_shortcode('pixomi_list', 'pixomi_list_shortcode');
}

/* =========================================================== */
/* 00. Team Members 
/* =========================================================== */
if (!function_exists('pixomi_team_member_shortcode')) {
	function pixomi_team_member_shortcode( $atts, $content = null) {
		extract( shortcode_atts( array(
			'style' => '1',
			'img' 	=> '',
			'name' 	=> '',
			'role'	=> '',
			'link'	=> '',
			'target' => '_self',
			'phone'	=> '',
			'email' => '',
			'skype' => '',
			'twitter' => '',
			'facebook' => '',
			'google' => '',
			'linkedin' => '',
			'instagram' => '',
		), $atts ) );
		
		// Url
		if($link != '') {
			$link_start = "<a href='".esc_url($link)."'>";
			$link_end = "</a>";
		} else {
			$link_start = "";
			$link_end = "";
		}

		// Link
		if($link != '') {
			$link_src = "<a href='".esc_url($link)."'>" . esc_html( 'View Profile', 'pixomi_core' ) . "</a>";
		} else {
			$link_src = "";
		}

		// Member Img
		if(!empty($img)) {
			$img_src = wp_get_attachment_image_src($img, 'full');
			$alt_text = get_post_meta($img , '_wp_attachment_image_alt', true);
			$member_img_src = '<div class="person-img">'.$link_start.'<img src="'.esc_url($img_src[0]).'" alt="'.esc_attr($alt_text).'" />'.$link_end.'</div>';
		} else{
			$member_img_src = "";
		}

		// Phone
		if($phone != '') {
			$phone_src = '<i class="droplet-old-telephone"></i><span>' . esc_html($phone) . '</span>';
		} else{
			$phone_src = ''; 
		}
		// Email
		if($email != '') {
			$email_src = '<i class="droplet-email"></i><span>' . esc_html($email) . '</span>';
		} else{
			$email_src = ''; 
		}
		// Skype
		if($skype != '') {
			$skype_src = '<i class="fa fa-skype"></i><span>' . esc_html($skype) . '</span>';
		} else{
			$skype_src = ''; 
		}

		// Social Icons
		if( $twitter != '' || $facebook != '' || $google != '' || $linkedin != '' || $instagram != '' ){
			$social_start = '<ul class="social-icons">';
			$social_end   = '</ul>';

			// Twitter
			if($twitter != '') {
				$twitter_src = '<li><a class="twitter" href="' .esc_url($twitter). '" target="_blank" ><i class="fa fa-twitter"></i></a></li>';
			} else{
				$twitter_src = ''; 
			}
			// Facebook
			if($facebook != '') {
				$facebook_src = '<li><a class="facebook" href="' .esc_url($facebook). '" target="_blank" ><i class="fa fa-facebook"></i></a></li>';
			} else{
				$facebook_src = ''; 
			}
			// Google Plus
			if($google != '') {
				$google_plus = '<li><a class="google-plus" href="' .esc_url($google). '" target="_blank" ><i class="fa fa-google-plus"></i></a></li>';
			} else{
				$google_plus = ''; 
			}
			// Linkedin
			if($linkedin != '') {
				$linkedin_src = '<li><a class="linkedin" href="' .esc_url($linkedin). '" target="_blank" ><i class="fa fa-linkedin"></i></a></li>';
			} else{
				$linkedin_src = ''; 
			}
			// Instagram
			if($instagram != '') {
				$instagram_src = '<li><a class="instagram" href="' .esc_attr($instagram). '" target="_blank" ><i class="fa fa-instagram"></i></a></li>';
			} else{
				$instagram_src = ''; 
			}
			
		}  else {
			$twitter_src = '';
			$facebook_src = ''; 
			$google_plus = ''; 
			$linkedin_src = ''; 
			$instagram_src = '';
			$social_start = '';
			$social_end = '';
		}   
		
		// Style Class
		$tm_style_class = '';
		if($style == '1'){
			$tm_style_class = 'tm-style-1';
		}
		elseif($style == '2'){
			$tm_style_class = 'tm-style-2';
		}

		// Output
    	$out = '<div class="' .esc_attr($tm_style_class). '">' .$member_img_src. '
    				<div class="person-caption">
    					'.$link_start.'<h4 class="name">' . esc_html($name) . '</h4>'.$link_end.'
    					<p class="role">' . esc_html($role) . '</p>
    					<p class="desc">' . do_shortcode($content) . '</p>
		        	    <p class="phone">' .$phone_src. '</p>    
                	    <p class="email">' .$email_src. '</p>    
                	    <p class="skype">' .$skype_src. '</p>    
    				</div>
    				' .$social_start. '' .$twitter_src. '' .$facebook_src. '' .$google_plus. '' .$linkedin_src. '' .$instagram_src. '' .$social_end. '
    				<div class="tm-btn">'.$link_src.'</div>
    			</div>';			

		return $out;
	}
	add_shortcode('pixomi_team_members', 'pixomi_team_member_shortcode');
}

/* =========================================================== */
/* 00. Project Info
/* =========================================================== */
if (!function_exists('pixomi_project_info_shortcode')) {
	function pixomi_project_info_shortcode( $atts, $content = null) {
		extract( shortcode_atts( array(
			'client' 	=> '',
			'date' 		=> '',
			'services' 	=> '',
			'link' 		=> '',
			'link_txt' 	=> '',
		), $atts ) );

		// Client
		if($client != '') {
			$client_src = '<div class="info-item"><strong>Client&nbsp;:&nbsp;&nbsp;</strong><span>' .esc_html($client). '</span></div>';
		} else{
			$client_src = ''; 
		}

		// Date
		if($date != '') {
			$date_src = '<div class="info-item"><strong>Date&nbsp;:&nbsp;&nbsp;</strong><span>' .esc_html($date). '</span></div>';
		} else{
			$date_src = ''; 
		}

		// Services
		if($services != '') {
			$services_src = '<div class="info-item"><strong>Services&nbsp;:&nbsp;&nbsp;</strong><span>' .esc_html($services). '</span></div>';
		} else{
			$services_src = ''; 
		}

		// Link
		if($link != '') {
			$link_src = '<div class="info-item"><strong>Website&nbsp;:&nbsp;&nbsp;</strong><a target="_blank" href="'.esc_url($link).'"><span>' .esc_html($link_txt). '</span></a></div>';
		} else{
			$link_src = ''; 
		}

		return '<div class="project-info">
                    ' .$client_src. '
                    ' .$date_src. '
                    ' .$services_src. '
                    ' .$link_src. '
                </div>';
		
	}
	add_shortcode('pixomi_project_info', 'pixomi_project_info_shortcode');
}

/* =========================================================== */
/* 00. Locations Boxes
/* =========================================================== */
if (!function_exists('pixomi_location_boxes_shortcode')) {
	function pixomi_location_boxes_shortcode( $atts, $content = null) {
		extract( shortcode_atts( array(
			'location_name' 	 => '',
			'location_address'   => '',
			'location_phone' 	 => '',
			'location_email' 	 => ''
		), $atts ) );
		
		// Output
    	$out = '<div class="location-box">
	        	    <div class="absolute-icon"><i class="droplet-location-marker"></i></div>
	        	    <h3 class="name">' . esc_html($location_name) . '</h3>    
	        	    <p class="address"><i class="droplet-location-marker"></i>' . esc_html($location_address) . '</p>    
	        	    <p class="phone"><i class="droplet-headphone"></i>' . esc_html($location_phone) . '</p>    
	        	    <p class="email"><i class="droplet-email"></i>' . esc_html($location_email) . '</p>    
    			</div>';			

		return $out;
		
	}
	add_shortcode('pixomi_location_boxes', 'pixomi_location_boxes_shortcode');
}