<?php

// Set vsiual composer Default Editor
if ( function_exists( 'vc_set_default_editor_post_types' ) ) {
	vc_set_default_editor_post_types( array(
		'page',
		'post',
		'portfolio'
	) );
}

// Set vsiual composer as theme
function pixomi_vcSetAsTheme() {
	vc_set_as_theme();
}
add_action( 'vc_before_init', 'pixomi_vcSetAsTheme' );

// Remove VC Teaser Metabox
if ( ! function_exists('pixomi_vc_remove_teaserbox') ) {
	function pixomi_vc_remove_teaserbox(){
		$post_types = get_post_types( '', 'names' );
		foreach ( $post_types as $post_type ) {
			remove_meta_box('vc_teaser',  $post_type, 'side');
		}
	}
}
add_action('do_meta_boxes', 'pixomi_vc_remove_teaserbox');

/* =========================================================== */
/* 00. Map to vc - Call To Action
/* =========================================================== */
function pixomi_callout_vc_map() {
	vc_map( array(
		"name"					=> esc_html__( "Call To Action", 'pixomi' ),
		"description"			=> esc_html__( "Callout With Different Styles", 'pixomi' ),
		"base"					=> "pixomi_callout",
		'category'				=> "Pixomi",
		"icon"      			=> get_template_directory_uri() . "/images/vc_icons/vc_cta.png",
		"params"				=> array(

			// Style
			array(
				"heading"		=> esc_html__( "Style", 'pixomi' ),
				"description"	=> esc_html__( "Choose Your Desired Call To Action Style", 'pixomi' ),
				"type"			=> "dropdown",
				"param_name"	=> "style",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> array(
	                esc_html__('Style 1', 'pixomi') => '1',
	                esc_html__('Style 2', 'pixomi') => '2',
				),
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Title
			array(
				"heading"		=> esc_html__( "Title", 'pixomi' ),
				"description"	=> esc_html__( "Enter Call to Action Title Here.", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "title",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Subtitle
			array(
				"heading"		=> esc_html__( "Subtitle", 'pixomi' ),
				"description"	=> esc_html__( "Enter Call to Action Subtitle Here", 'pixomi' ),
				"type"			=> "textarea",
				"param_name"	=> "subtitle",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
				'dependency' => Array( 'element' => 'style', 'value' => Array('2') ),
			),

			// Title Color
			array(
				"heading"		=> esc_html__( "Title Color", 'pixomi' ),
	            "description"   => esc_html__("Choose Your Desired Title Color",'pixomi'),
				"param_name"	=> "cta_title_color",
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Desc Color
			array(
				"heading"		=> esc_html__( "Description Color", 'pixomi' ),
	            "description"   => esc_html__("Choose Your Desired Description Color",'pixomi'),
				"param_name"	=> "cta_desc_color",
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
				'dependency' => Array( 'element' => 'style', 'value' => Array('2') ),
			),
			
			// Bg Color
			array(
				"heading"		=> esc_html__( "Background Color", 'pixomi' ),
	            "description"   => esc_html__("Choose Your Desired Callout Background Color Color",'pixomi'),
				"param_name"	=> "cta_bg_color",
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Bg Image
			array(
				"heading"		=> esc_html__( "Background Image", 'pixomi' ),
				"description"	=> esc_html__( "Upload Background Image for Callout.", 'pixomi' ),
				"type"			=> "attach_image",
				"param_name"	=> "cta_bg_img",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Btn Text
			array(
				"heading"		=> esc_html__( "Button Text", 'pixomi' ),
				"description"	=> esc_html__( "Enter Button 1 Text", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "btn_txt",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Button', 'pixomi' ),
			),

			// Btn Link
			array(
				"heading"		=> esc_html__( "Button Link", 'pixomi' ),
				"description"	=> esc_html__( "Enter Button 1 Link with http://", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "btn_link",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Button', 'pixomi' ),
			),

			// Btn Link Target
			array(
				"heading"		=> esc_html__( "Button Link Target", 'pixomi' ),
				"description"	=> esc_html__( "Whether You Want to link to Open Same Window or Separate Window.", 'pixomi' ),
				"type"			=> "dropdown",
				"admin_label"	=> false,
				"class"			=> "",
				"param_name"	=> "btn_target",
				"value"			=> array(
	                esc_html__('Same Window', 'pixomi') => '_self',
	                esc_html__('New Window', 'pixomi') => '_blank',
				),
				"group"			=> esc_html__( 'Button', 'pixomi' ),
			),

			// Btn Bg Color
			array(
				"heading"		=> esc_html__( "Button Background Color", 'pixomi' ),
				"description"	=> esc_html__( "Choose Your Desired Button Background Color", 'pixomi' ),
				"type"			=> "colorpicker",
				"param_name"	=> "btn_bg_color",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Button', 'pixomi' ),
			),

			// Btn Text Color
			array(
				"heading"		=> esc_html__( "Button Text Color", 'pixomi' ),
				"description"	=> esc_html__( "Choose Your Desired Button Text Color", 'pixomi' ),
				"type"			=> "colorpicker",
				"param_name"	=> "btn_txt_color",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Button', 'pixomi' ),
			),

			// Btn Radius
			array(
				"heading"		=> esc_html__( "Button Radius", 'pixomi' ),
				"description"	=> esc_html__( "Enter Button Radius in px", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "btn_radius",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Button', 'pixomi' ),
			),
		)
	) );
}
add_action( 'vc_before_init', 'pixomi_callout_vc_map' );

/* =========================================================== */
/* 00. Map to vc - Recent Posts
/* =========================================================== */
function pixomi_recent_posts_vc_map() {
	vc_map( array(
		"name"			=> esc_html__( "Recent Posts", 'pixomi' ),
		"description"	=> esc_html__( "Recent Posts With Title and Meta", 'pixomi' ),
		"base"			=> "pixomi_recent_posts",
		'category'		=> "Pixomi",
		"icon"      	=> get_template_directory_uri() . "/images/vc_icons/vc_recent_posts.png",
		"params"		=> array(
			
			// Posts
			array(
				"heading"		=> esc_html__( "Number of Posts", 'pixomi' ),
				"description"	=> esc_html__( "Enter How Many Posts Your Want to Show.", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "posts",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "4",
			),

			// Cat
			array(
				"heading"		=> esc_html__( "Blog Categories", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Desired Blog Category to Show Posts or 'All' for All Posts.", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "categories",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "all",
			),
		)
	) );
}
add_action( 'vc_before_init', 'pixomi_recent_posts_vc_map' );

/* =========================================================== */
/* 00. Map to vc - Iconboxes
/* =========================================================== */
function pixomi_iconboxes_vc_map() {
	vc_map( array(
		"name"					=> esc_html__( "Iconboxes", 'pixomi' ),
		"description"			=> esc_html__( "Iconboxes With Icon and Image.", 'pixomi' ),
		"base"					=> "pixomi_iconboxes",
		'category'				=> "Pixomi",
		"icon"      	        => get_template_directory_uri() . "/images/vc_icons/vc_icon_box.png",
		"params"				=> array(

			// Iconbox Style
			array(
				"heading"		=> esc_html__( "Iconbox Styles", 'pixomi' ),
				"description"   => esc_html__( "Choose Your Desired Iconbox Styles", 'pixomi' ),
				"type"			=> "dropdown",
				"admin_label"	=> false,
				"class"			=> "",
				"param_name"	=> "style",
				"value"			=> array(
	                esc_html__('Iconbox Style 1', 'pixomi')  => '1',
	                esc_html__('Iconbox Style 2', 'pixomi')  => '2',
	                esc_html__('Iconbox Style 3', 'pixomi')  => '3',
				),
				"group"			=> esc_html__( 'General', 'pixomi' ),
			),

			// Iconbox Icon
			array(
				"heading"		=> esc_html__( "Font Icon", 'pixomi' ),
				"description"	=> esc_html__( "Can be any Fontawesome Icon (fa-phone)", 'pixomi' ),
				"type"			=> "textfield",
				"admin_label"	=> false,
				"class"			=> "",
				"param_name"	=> "icon",
				"value"			=> "fa-cog",
				"group"			=> esc_html__( 'General', 'pixomi' ),
			),

			// Iconbox Image
			array(
				"heading"		=> esc_html__( "Iconbox Image", 'pixomi' ),
				"description"	=> esc_html__( "Upload an Image Icon Insted of Font Icon", 'pixomi' ),
				"type"			=> "attach_image",
				"admin_label"	=> false,
				"class"			=> "",
				"param_name"	=> "iconimg",
				"value"			=> "",
				"group"			=> esc_html__( 'General', 'pixomi' ),
			),

			// Custom Class
			array(
				"heading"		=> esc_html__( "Iconbox Custom Class", 'pixomi' ),
				"description"	=> esc_html__( "Add an Extra or Custom Class to Style Iconbox", 'pixomi' ),
				"type"			=> "textfield",
				"admin_label"	=> false,
				"class"			=> "",
				"param_name"	=> "class",
				"value"			=> "",
				"group"			=> esc_html__( 'General', 'pixomi' ),
			),

			// Iconbox Title
			array(
				"heading"		=> esc_html__( "Iconbox Title", 'pixomi' ),
				"description"	=> esc_html__( "Enter Iconbox Title If you Dont Want to use Title Leave it Blank.", 'pixomi' ),
				"type"			=> "textfield",
				"admin_label"	=> true,
				"class"			=> "",
				"param_name"	=> "title",
				"value"			=> "",
				"group"			=> esc_html__( 'Content', 'pixomi' ),
			),

			// Iconbox Content
			array(
				"heading"		=> esc_html__( "Iconbox Content", 'pixomi' ),
				"description"	=> esc_html__( "Enter Iconbox Content Goes Here.", 'pixomi' ),
				"type"			=> "textarea_html",
				"admin_label"	=> false,
				"class"			=> "",
				"param_name"	=> "content",
				"value"			=> "Lorem ipsum dolor sit amet, consectetur adipisicing elit. Doloribus, debitis.",
				"group"			=> esc_html__( 'Content', 'pixomi' ),
			),

			// Btn Txt
			array(
				"heading"		=> esc_html__( "Icon Box Button Text", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Icon Box Button Text Here", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "btn_txt",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Content', 'pixomi' ),
			),

			// Btn Link
			array(
				"heading"		=> esc_html__( "Button Link", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Button Link Here with http://", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "btn_link",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Content', 'pixomi' ),
			),

			// Link Target
			array(
				"heading"		=> esc_html__( "Link Target", 'pixomi' ),
				"description"   => esc_html__( "Whether You Want to link to Open Same Window or Separate Window.", 'pixomi' ),
				"type"			=> "dropdown",
				"admin_label"	=> false,
				"class"			=> "",
				"param_name"	=> "target",
				"value"			=> array(
	                esc_html__('Same Window', 'pixomi')  => '_self',
	                esc_html__('New Window', 'pixomi')  => '_blank',
				),
				"group"	=> esc_html__( 'Content', 'pixomi' ),
			),

			// Icon Color
			array(
				"heading"		=> esc_html__( "Icon Color", 'pixomi' ),
				"description"	=> esc_html__( "Select Your Desired Icon Color", 'pixomi' ),
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"param_name"	=> "icon_color",
				"value"			=> "",
				"group"			=> esc_html__( 'Styling', 'pixomi' ),
			),

			// Icon Background Color
			array(
				"heading"		=> esc_html__( "Icon Background Color", 'pixomi' ),
				"description"	=> esc_html__( "Select Your Desired Icon Background Color", 'pixomi' ),
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"param_name"	=> "icon_bg_color",
				"value"			=> "",
				"group"			=> esc_html__( 'Styling', 'pixomi' ),
			),

			// Title Color
			array(
				"heading"		=> esc_html__( "Title Color", 'pixomi' ),
				"description"	=> esc_html__( "Select Your Desired Title Color", 'pixomi' ),
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"param_name"	=> "title_color",
				"value"			=> "",
				"group"			=> esc_html__( 'Styling', 'pixomi' ),
			),

			// Desc Color
			array(
				"heading"		=> esc_html__( "Description Color", 'pixomi' ),
				"description"	=> esc_html__( "Select Your Desired Desvription Color", 'pixomi' ),
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"param_name"	=> "desc_color",
				"value"			=> "",
				"group"			=> esc_html__( 'Styling', 'pixomi' ),
			),

			// Iconbox3 Bg Color
			array(
				"heading"		=> esc_html__( "Iconbox Style 3 Background Color", 'pixomi' ),
				"description"	=> esc_html__( "Select Your Desired Iconbox Style 3 Background Color", 'pixomi' ),
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"param_name"	=> "iconbox3_bg_color",
				"value"			=> "",
				"group"			=> esc_html__( 'Styling', 'pixomi' ),
				'dependency' => Array( 'element' => 'style', 'value' => Array('3') ),
			),

			// Btn Color
			array(
				"heading"		=> esc_html__( "Button Background Color", 'pixomi' ),
				"description"	=> esc_html__( "Select Your Desired Button Background Color", 'pixomi' ),
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"param_name"	=> "btn_bg_color",
				"value"			=> "",
				"group"			=> esc_html__( 'Styling', 'pixomi' ),
			),
		)
	) );
}
add_action( 'vc_before_init', 'pixomi_iconboxes_vc_map' );

/* =========================================================== */
/* 00. Map to vc - Image Box
/* =========================================================== */
function pixomi_imagebox_vc_map() {
	vc_map( array(
		"name"					=> esc_html__( "Image Box", 'pixomi' ),
		"description"			=> esc_html__( "Image Box With Content and Button", 'pixomi' ),
		"base"					=> "pixomi_imagebox",
		'category'				=> "Pixomi",
		"icon"      	        => get_template_directory_uri() . "/images/vc_icons/vc_imagebox.png",
		"params"				=> array(
			
			// Style
			array(
				"heading"		=> esc_html__( "Image Box Style", 'pixomi' ),
				"description"   => esc_html__( "Choose Your Desired Image Box Style", 'pixomi' ),
				"type"			=> "dropdown",
				"param_name"	=> "style",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> array(
                esc_html__('Image on Top', 'pixomi')  => '1',
                esc_html__('Image on Left', 'pixomi') => '2',
				),
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Image
			array(
				"heading"		=> esc_html__( "Image", 'pixomi' ),
				"description"	=> esc_html__( "Upload Your Image for Image Box.", 'pixomi' ),
				"type"			=> "attach_image",
				"param_name"	=> "img",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Title
			array(
				"heading"		=> esc_html__( "Image Box Title", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Image Box Title Here", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "title",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Content
			array(
				"heading"		=> esc_html__( "Image Box Content", 'pixomi' ),
				"heading"		=> esc_html__( "Enter Your Image Box Content Here.", 'pixomi' ),
				"type"			=> "textarea_html",
				"param_name"	=> "content",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "Lorem ipsum dolor sit amet, consectetur adipisicing elit. Magni ipsum, error consectetur, id quo praesentium atque eaque eius nam veritatis provident. Quaerat voluptas eos at ipsa, tempora sunt.",
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Btn Txt
			array(
				"heading"		=> esc_html__( "Image Box Button Text", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Image Box Button Text Here", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "btn_txt",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Btn Link
			array(
				"heading"		=> esc_html__( "Button Link", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Button Link Here with http://", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "btn_link",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Link Target
			array(
				"heading"		=> esc_html__( "Link Target", 'pixomi' ),
				"description"   => esc_html__( "Whether You Want to link to Open Same Window or Separate Window.", 'pixomi' ),
				"type"			=> "dropdown",
				"admin_label"	=> false,
				"class"			=> "",
				"param_name"	=> "target",
				"value"			=> array(
	                esc_html__('Same Window', 'pixomi')  => '_self',
	                esc_html__('New Window', 'pixomi')  => '_blank',
				),
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Title Color
			array(
				"heading"		=> esc_html__( "Title Color", 'pixomi' ),
				"description"	=> esc_html__( "Choose Your Desired Title Color", 'pixomi' ),
				"param_name"	=> "title_color",
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Styling', 'pixomi' ),
			),

			// Desc Color
			array(
				"heading"		=> esc_html__( "Descritpion Color", 'pixomi' ),
				"description"	=> esc_html__( "Choose Your Desired Descritpion Color", 'pixomi' ),
				"param_name"	=> "desc_color",
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Styling', 'pixomi' ),
			),
			
			// Btn Bg Color
			array(
				"heading"		=> esc_html__( "Button Background Color", 'pixomi' ),
				"description"	=> esc_html__( "Choose Your Desired Button Background Color", 'pixomi' ),
				"param_name"	=> "btn_bg_color",
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Styling', 'pixomi' ),
			),
		)
	) );
}
add_action( 'vc_before_init', 'pixomi_imagebox_vc_map' );

/* =========================================================== */
/* 00. Map to vc - Counter
/* =========================================================== */
function pixomi_counter_vc_map() {
	vc_map( array(
		"name"					=> esc_html__( "Counter", 'pixomi' ),
		"description"			=> esc_html__( "Counter With Title and Icon", 'pixomi' ),
		"base"					=> "pixomi_counter",
		'category'				=> "Pixomi",
		"icon"      	        => get_template_directory_uri() . "/images/vc_icons/vc_counter.png",
		"params"				=> array(
			
			// Number
			array(
				"heading"		=> esc_html__( "Counter Number", 'pixomi' ),
				"description"	=> esc_html__( "Enter Counter Number ie '999' ", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "number",
				"admin_label"	=> true,
				"class"			=> "",
				"value"		=> esc_html__( "999", 'pixomi' ),
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Title
			array(
				"heading"		=> esc_html__( "Counter Title", 'pixomi' ),
				"description"	=> esc_html__( "Enter Counter Title Here", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "title",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Number Color
			array(
				"heading"		=> esc_html__( "Counter Number Color", 'pixomi' ),
				"description"	=> esc_html__( "Choose Your Desired Counter Number Color", 'pixomi' ),
				"param_name"	=> "number_color",
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Styling', 'pixomi' ),
			),

			// Title Color
			array(
				"heading"		=> esc_html__( "Counter Title Color", 'pixomi' ),
				"description"	=> esc_html__( "Choose Your Desired Counter Title Color", 'pixomi' ),
				"param_name"	=> "title_color",
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Styling', 'pixomi' ),
			),

		)
	) );
}
add_action( 'vc_before_init', 'pixomi_counter_vc_map' );

/* =========================================================== */
/* 00. Map to vc - Testimonial Slider
/* =========================================================== */
function pixomi_testimonial_slider_vc_map() {
	vc_map( array(
		"name"					=> esc_html__( "Testimonial Slider", 'pixomi' ),
		"description"			=> esc_html__( "Testimonials With Slider", 'pixomi' ),
		"base"					=> "pixomi_testimonial_slider",
		'category'				=> "Pixomi",
		"icon"      	        => get_template_directory_uri() . "/images/vc_icons/vc_testimonial_slider.png",
		"params"				=> array(
			
			// Testimonial Slie 1
			array(
				"heading"		=> esc_html__( "Client Image", 'pixomi' ),
				"description"	=> esc_html__( "Upload Your Client Image Size 200x200", 'pixomi' ),
				"type"			=> "attach_image",
				"admin_label"	=> false,
				"param_name"	=> "slide_1_img",
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Testimonial Slide 1', 'pixomi' )
			),

			array(
				"heading"		=> esc_html__( "Client Name", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Client Name Here.", 'pixomi' ),
				"type"			=> "textfield",
				"admin_label"	=> false,
				"param_name"	=> "slide_1_client",
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Testimonial Slide 1', 'pixomi' )
			),

			array(
				"heading"		=> esc_html__( "Client Info", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Client Info Here.", 'pixomi' ),
				"type"			=> "textfield",
				"admin_label"	=> false,
				"param_name"	=> "slide_1_info",
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Testimonial Slide 1', 'pixomi' )
			),

			array(
				"heading"		=> esc_html__( "Client Testimonial", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Client Testimonial Here.", 'pixomi' ),
				"type"			=> "textarea",
				"admin_label"	=> false,
				"param_name"	=> "slide_1_content",
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Testimonial Slide 1', 'pixomi' )
			),
			
			// Testimonial Slie 2
			array(
				"heading"		=> esc_html__( "Client Image", 'pixomi' ),
				"description"	=> esc_html__( "Upload Your Client Image Size 200x200", 'pixomi' ),
				"type"			=> "attach_image",
				"admin_label"	=> false,
				"param_name"	=> "slide_2_img",
				"value"			=> "",
				"class"			=> "",
				"group"			=> esc_html__( 'Testimonial Slide 2', 'pixomi' )
			),

			array(
				"heading"		=> esc_html__( "Client Name", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Client Name Here.", 'pixomi' ),
				"type"			=> "textfield",
				"admin_label"	=> false,
				"param_name"	=> "slide_2_client",
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Testimonial Slide 2', 'pixomi' )
			),

			array(
				"heading"		=> esc_html__( "Client Info", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Client Info Here.", 'pixomi' ),
				"type"			=> "textfield",
				"admin_label"	=> false,
				"param_name"	=> "slide_2_info",
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Testimonial Slide 2', 'pixomi' )
			),

			array(
				"heading"		=> esc_html__( "Client Testimonial", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Client Testimonial Here.", 'pixomi' ),
				"type"			=> "textarea",
				"admin_label"	=> false,
				"param_name"	=> "slide_2_content",
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Testimonial Slide 2', 'pixomi' )
			),
			
			// Testimonial Slie 3
			array(
				"heading"		=> esc_html__( "Client Image", 'pixomi' ),
				"description"	=> esc_html__( "Upload Your Client Image Size 200x200", 'pixomi' ),
				"type"			=> "attach_image",
				"admin_label"	=> false,
				"param_name"	=> "slide_3_img",
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Testimonial Slide 3', 'pixomi' )
			),

			array(
				"heading"		=> esc_html__( "Client Name", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Client Name Here.", 'pixomi' ),
				"type"			=> "textfield",
				"admin_label"	=> false,
				"param_name"	=> "slide_3_client",
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Testimonial Slide 3', 'pixomi' )
			),

			array(
				"heading"		=> esc_html__( "Client Info", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Client Info Here.", 'pixomi' ),
				"type"			=> "textfield",
				"admin_label"	=> false,
				"param_name"	=> "slide_3_info",
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Testimonial Slide 3', 'pixomi' )
			),

			array(
				"heading"		=> esc_html__( "Client Testimonial", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Client Testimonial Here.", 'pixomi' ),
				"type"			=> "textarea",
				"admin_label"	=> false,
				"param_name"	=> "slide_3_content",
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Testimonial Slide 3', 'pixomi' )
			),

			array(
				"heading"		=> esc_html__( "Client Title Color", 'pixomi' ),
				"param_name"	=> "title_color",
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Styling', 'pixomi' ),
			),

			array(
				"heading"		=> esc_html__( "Client Role Color", 'pixomi' ),
				"param_name"	=> "role_color",
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Styling', 'pixomi' ),
			),

			array(
				"heading"		=> esc_html__( "Client Testimonial Color", 'pixomi' ),
				"param_name"	=> "testimonial_color",
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Styling', 'pixomi' ),
			),

		)
	
	) );
}
add_action( 'vc_before_init', 'pixomi_testimonial_slider_vc_map' );

/* =========================================================== */
/* 00. Map to vc - Testimonial Box
/* =========================================================== */
function pixomi_testimonial_boxes_vc_map() {
	vc_map( array(
		"name"					=> esc_html__( "Testimonial Box", 'pixomi' ),
		"description"			=> esc_html__( "Testimonials With Box", 'pixomi' ),
		"base"					=> "pixomi_testimonial_boxes",
		'category'				=> "Pixomi",
		"icon"      	        => get_template_directory_uri() . "/images/vc_icons/vc_testimonial_box.png",
		"params"				=> array(
			
			array(
				"heading"		=> esc_html__( "Client Image", 'pixomi' ),
				"description"	=> esc_html__( "Upload Your Client Image Size 200x200", 'pixomi' ),
				"type"			=> "attach_image",
				"admin_label"	=> false,
				"param_name"	=> "client_img",
				"value"			=> "",
				"class"			=> "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			array(
				"heading"		=> esc_html__( "Client Name", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Client Name", 'pixomi' ),
				"type"			=> "textfield",
				"admin_label"	=> true,
				"param_name"	=> "client_name",
				"value"			=> "",
				"class"			=> "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			array(
				"heading"		=> esc_html__( "Client Info", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Client Info", 'pixomi' ),
				"type"			=> "textfield",
				"admin_label"	=> true,
				"param_name"	=> "client_info",
				"value"			=> "",
				"class"			=> "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			array(
				"heading"		=> esc_html__( "Client Testimonial", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Client Testimonial Here.", 'pixomi' ),
				"type"			=> "textarea",
				"admin_label"	=> false,
				"param_name"	=> "client_content",
				"value"			=> "",
				"class"			=> "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			array(
				"heading"		=> esc_html__( "Box Background Color", 'pixomi' ),
				"param_name"	=> "bg_color",
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Styling', 'pixomi' ),
			),

			array(
				"heading"		=> esc_html__( "Client Testimonial Color", 'pixomi' ),
				"param_name"	=> "text_color",
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Styling', 'pixomi' ),
			),

			array(
				"heading"		=> esc_html__( "Client Title Color", 'pixomi' ),
				"param_name"	=> "title_color",
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Styling', 'pixomi' ),
			),

			array(
				"heading"		=> esc_html__( "Client Role Color", 'pixomi' ),
				"param_name"	=> "role_color",
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Styling', 'pixomi' ),
			),

			array(
				"heading"		=> esc_html__( "Box Quote Icon Color", 'pixomi' ),
				"param_name"	=> "icon_color",
				"type"			=> "colorpicker",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Styling', 'pixomi' ),
			),
		)
	
	) );
}
add_action( 'vc_before_init', 'pixomi_testimonial_boxes_vc_map' );

/* =========================================================== */
/* 00. Map to vc - Special Heading
/* =========================================================== */
function pixomi_special_heading_vc_map() {
	vc_map( array(
		"name"					=> esc_html__( "Special Heading", 'pixomi' ),
		"description"			=> esc_html__( "Special Heading With Styles", 'pixomi' ),
		"base"					=> "pixomi_special_heading",
		'category'				=> "Pixomi",
		"icon"      	        => get_template_directory_uri() . "/images/vc_icons/vc_sph.png",
		"params"				=> array(
			
			// Heading
			array(
				"heading"		=> esc_html__( "Heading", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Heading Text Here.", 'pixomi' ),
				"type"			=> "textarea",
				"param_name"	=> "heading",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),
			
			// SubHeading
			array(
				"heading"		=> esc_html__( "Sub Heading", 'pixomi' ),
				"description"	=> esc_html__( "If you dont want to use SubHeading Just Leave it Blank", 'pixomi' ),
				"type"			=> "textarea",
				"param_name"	=> "subheading",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Switch Btn Icon
			array(
				"heading"		=> esc_html__( "Enable Heading Seperator", 'pixomi' ),
				"description"   => esc_html__( "If you Dont Want to use Seperator then simply select no.", 'pixomi' ),
				"type"			=> "dropdown",
				"param_name"	=> "switch_sep",
				"admin_label"	=> false,
				"class"			=> "",
				"value"		    => 'yes',
				"value"			=> array(
	                esc_html__('Yes', 'pixomi')  => 'yes',
	                esc_html__('No', 'pixomi')  => 'no',
				),
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Heading Size
			array(
	            "heading" => esc_html__("Heading Size",'pixomi'),
	            "description" => esc_html__("Enter Your Desired Heading Size in px",'pixomi'),
	            "param_name" => "heading_size",
	            "type" => "textfield",
	            "class" => "",
	            "value" => "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
	        ),

			// Sub Heading Size
			array(
	            "heading" => esc_html__("Sub Heading Size",'pixomi'),
	            "description" => esc_html__("Enter Your Desired Sub Heading Size in px",'pixomi'),
	            "param_name" => "subheading_size",
	            "type" => "textfield",
	            "class" => "",
	            "value" => "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
	        ),
		
			// Heading Weight
			array(
	            "heading" => esc_html__("Heading Weight",'pixomi'),
	            "description" => esc_html__("Enter Your Desired Heading Weight ie 400, 500, 600",'pixomi'),
	            "param_name" => "heading_weight",
	            "type" => "textfield",
	            "class" => "",
	            "value" => "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
	        ),

			// Heading Line Height
			array(
	            "heading" => esc_html__("Heading Line Height",'pixomi'),
	            "description" => esc_html__("Enter Your Desired Heading Line Height in px",'pixomi'),
	            "param_name" => "line_height",
	            "type" => "textfield",
	            "class" => "",
	            "value" => "",
				"group"	=> esc_html__( 'General', 'pixomi' ),
	        ),

			// Align
			array(
				"heading"		=> esc_html__( "Text Align", 'pixomi' ),
				"description"	=> esc_html__( "Select Your Desired Text Align", 'pixomi' ),
				"type"			=> "dropdown",
				"param_name"	=> "align",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> array(
	                esc_html__('Center', 'pixomi') => 'center',
	                esc_html__('Left', 'pixomi') => 'left',
	                esc_html__('Right', 'pixomi') => 'right',
				),
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Text Transform
			array(
				"heading"		=> esc_html__( "Heading Text Transform", 'pixomi' ),
				"description"	=> esc_html__( "Choose Your Heading Text Transform", 'pixomi' ),
				"type"			=> "dropdown",
				"param_name"	=> "transform",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> array(
	                esc_html__('None', 'pixomi')       => 'none',
	                esc_html__('Capitalize', 'pixomi') => 'capitalize',
	                esc_html__('Uppercase', 'pixomi')  => 'uppercase',
	                esc_html__('Lowercase', 'pixomi')  => 'lowercase',
				),
				"group"	=> esc_html__( 'General', 'pixomi' ),
			),

			// Margin
			array(
	            "heading" => esc_html__("Heading Margin",'pixomi'),
	            "description" => esc_html__("Enter Margin to Heading ie Top, Right, Bottom, Left ie 0px 0px 20px 0px",'pixomi'),
	            "param_name" => "margin",
	            "type" => "textfield",
	            "class" => "",
	            "value" => "0px 0px 30px 0px",
				"group"	=> esc_html__( 'General', 'pixomi' ),
	        ),	

			// Heading Color
			array(
				"heading"		=> esc_html__( "Heading Color", 'pixomi' ),
				"description"	=> esc_html__( "Choose Your Desired Heading Color", 'pixomi' ),
				"type"			=> "colorpicker",
				"param_name"	=> "heading_color",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Styling', 'pixomi' ),
			),

			// Sub Heading Color
			array(
				"heading"		=> esc_html__( "Sub Heading Color", 'pixomi' ),
				"description"	=> esc_html__( "Choose Your Desired Sub Heading Color", 'pixomi' ),
				"type"			=> "colorpicker",
				"param_name"	=> "subheading_color",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Styling', 'pixomi' ),
			),

			// Sep Color
			array(
				"heading"		=> esc_html__( "Heading Seperator Color", 'pixomi' ),
				"description"	=> esc_html__( "Choose Your Desired Heading Seperator Color", 'pixomi' ),
				"type"			=> "colorpicker",
				"param_name"	=> "sep_color",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> "",
				"group"	=> esc_html__( 'Styling', 'pixomi' ),
			),
							
		)
	) );
}
add_action( 'vc_before_init', 'pixomi_special_heading_vc_map' );

/* =========================================================== */
/* 00. Map to vc - List
/* =========================================================== */
function pixomi_list_vc_map() {
	vc_map( array(
		"name"			=> esc_html__( "List", 'pixomi' ),
		"description"	=> esc_html__( "Add Unordered List", 'pixomi' ),
		"base"			=> "pixomi_list",
		'category'		=> "Pixomi",
		"icon"      	        => get_template_directory_uri() . "/images/vc_icons/vc_list.png",
		"params"		=> array(
			
			// Iconbox Content
			array(
				"heading"		=> esc_html__( "Enter Unordered List Here", 'pixomi' ),
				"description"	=> esc_html__( "Enter Unordered List Here by Clicking on List Button on Editor.", 'pixomi' ),
				"type"			=> "textarea_html",
				"admin_label"	=> false,
				"param_name"	=> "content",
				"value"			=> "<ul><li>We can bring you ideas from many Strategies</li><li>Manage your time so you will get more done</li><li>We know that too often strategy projects fail</li></ul>",
			),
		)
	) );
}
add_action( 'vc_before_init', 'pixomi_list_vc_map' );

/* =========================================================== */
/* 00. Map to vc - Team Members
/* =========================================================== */
function pixomi_team_members_vc_map() {
	vc_map( array(
		"name"					=> esc_html__( "Team Member", 'pixomi' ),
		"description"			=> esc_html__( "Team Member With List and Grid.", 'pixomi' ),
		"base"					=> "pixomi_team_members",
		'category'				=> "Pixomi",
		"icon"      	        => get_template_directory_uri() . "/images/vc_icons/vc_members.png",
		"params"				=> array(

			// Style
			array(
				"heading"		=> esc_html__( "Team Member Style", 'pixomi' ),
				"description"   => esc_html__( "Choose Your Desired Team Member Style", 'pixomi' ),
				"type"			=> "dropdown",
				"param_name"	=> "style",
				"admin_label"	=> false,
				"class"			=> "",
				"value"			=> array(
	                esc_html__('Team Grid', 'pixomi')  => '1',
	                esc_html__('Team List', 'pixomi')  => '2',
				),
				"group"			=> esc_html__( 'General', 'pixomi' ),
			),

			// Image
			array(
				"heading"		=> esc_html__( "Member Profile Image", 'pixomi' ),
				"description"	=> esc_html__( "Upload Your Team Member Profile Image.", 'pixomi' ),
				"type"			=> "attach_image",
				"param_name"	=> "img",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'General', 'pixomi' ),
			),

			// Name
			array(
				"heading"		=> esc_html__( "Team Member Name", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Team Member Name.", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "name",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'General', 'pixomi' ),
			),

			// Role
			array(
				"heading"		=> esc_html__( "Team Member Role", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Team Member Role.", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "role",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'General', 'pixomi' ),
			),

			// Info
			array(
				"heading"		=> esc_html__( "Team Member Info", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Team Member Info.", 'pixomi' ),
				"type"			=> "textarea_html",
				"param_name"	=> "content",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "Aliquam hendrerit a augue Pellentes que id erat quis sollicitudin nulla mattis rsitmet sollicitudin aliquam.",
				"group"			=> esc_html__( 'General', 'pixomi' ),
			),

			// Link
			array(
				"heading"		=> esc_html__( "Team Member Link", 'pixomi' ),
				"description"	=> esc_html__( "Want to Link Your Team Member to External Page or Website.", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "link",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'General', 'pixomi' ),
			),

			// Link Target
			array(
				"heading"		=> esc_html__( "Link Target", 'pixomi' ),
				"description"	=> esc_html__( "Whether You Want to link to Open Same Window or Separate Window.", 'pixomi' ),
				"type"			=> "dropdown",
				"admin_label"	=> false,
				"class"			=> "",
				"param_name"	=> "target",
				"value"			=> array(
	                esc_html__('Same Window', 'pixomi') => '_self',
	                esc_html__('New Window', 'pixomi') => '_blank',
				),
				"group"			=> esc_html__( 'General', 'pixomi' ),
			),

			// Phone Number
			array(
				"heading"		=> esc_html__( "Phone Number", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Team Member Phone Number", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "phone",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Contact Info', 'pixomi' ),
			),

			// Email
			array(
				"heading"		=> esc_html__( "Email Address", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Team Member Email Address", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "email",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Contact Info', 'pixomi' ),
			),
			
			// Skype
			array(
				"heading"		=> esc_html__( "Skype Name", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Team Member Skype Name", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "skype",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Contact Info', 'pixomi' ),
			),
			
			// Twitter
			array(
				"heading"		=> esc_html__( "Twitter Url", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Team Member Twitter Url With http://", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "twitter",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Social Links', 'pixomi' ),
			),

			// Facebook
			array(
				"heading"		=> esc_html__( "Facebook Url", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Team Member Facebook Url With http://", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "facebook",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Social Links', 'pixomi' ),
			),

			// google plus
			array(
				"heading"		=> esc_html__( "Google Plus Url", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Team Member Google Plus Url With http://", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "google",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Social Links', 'pixomi' ),
			),

			// Linkedin
			array(
				"heading"		=> esc_html__( "Linkedin Url", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Team Member Linkedin Url With http://", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "linkedin",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Social Links', 'pixomi' ),
			),
		
			// Instagram
			array(
				"heading"		=> esc_html__( "Instagarm Url", 'pixomi' ),
				"description"	=> esc_html__( "Enter Your Team Member Instagarm Url With http://", 'pixomi' ),
				"type"			=> "textfield",
				"param_name"	=> "instagram",
				"admin_label"	=> true,
				"class"			=> "",
				"value"			=> "",
				"group"			=> esc_html__( 'Social Links', 'pixomi' ),
			),						
		)
	) );
}
add_action( 'vc_before_init', 'pixomi_team_members_vc_map' );

/* =========================================================== */
/* 00. Map to vc - Project Info
/* =========================================================== */
function pixomi_project_info_vc_map() {
	vc_map( array(
		"name"					=> esc_html__( "Project Info", 'pixomi' ),
		"description"			=> esc_html__( "Enter Your Project Info Here", 'pixomi' ),
		"base"					=> "pixomi_project_info",
		'category'				=> "Pixomi",
		"icon"      	        => get_template_directory_uri() . "/images/vc_icons/vc_project_info.png",
		"params"				=> array(

			// Client
			array(
	            "heading" => esc_html__("Client Name",'pixomi'),
	            "description" => esc_html__("Enter Your Project Client Name",'pixomi'),
	            "param_name" => "client",
	            "type" => "textfield",
	            "class" => "",
	        ),

			// Date
			array(
	            "heading" => esc_html__("Project Date",'pixomi'),
	            "description" => esc_html__("Enter Your Project date here",'pixomi'),
	            "param_name" => "date",
	            "type" => "textfield",
	            "class" => "",
	        ),

	        // Services
			array(
	            "heading" => esc_html__("Project Services",'pixomi'),
	            "description" => esc_html__("Enter What kind of services you provide for this project",'pixomi'),
	            "param_name" => "services",
	            "type" => "textfield",
	            "class" => "",
	        ),

	        // Link
			array(
	            "heading" => esc_html__("Proejct LInk",'pixomi'),
	            "description" => esc_html__("Enter Your project link or website with http://",'pixomi'),
	            "param_name" => "link",
	            "type" => "textfield",
	            "class" => "",
	        ),

	       	// Link Text
			array(
	            "heading" => esc_html__("Proejct LInk Text",'pixomi'),
	            "description" => esc_html__("Enter Your project link Text Here",'pixomi'),
	            "param_name" => "link_txt",
	            "type" => "textfield",
	            "class" => "",
	        ),

		)
	) );
}
add_action( 'vc_before_init', 'pixomi_project_info_vc_map' );

/* =========================================================== */
/* 00. Map to vc - Location Boxes
/* =========================================================== */
function pixomi_location_boxes_vc_map() {
	vc_map( array(
		"name"					=> esc_html__( "Location Boxes", 'pixomi' ),
		"description"			=> esc_html__( "Display Your Multiple Location Boxes", 'pixomi' ),
		"base"					=> "pixomi_location_boxes",
		'category'				=> "Pixomi",
		"icon"      	        => get_template_directory_uri() . "/images/vc_icons/vc_location_box.png",
		"params"				=> array(

			array(
	            "heading" => esc_html__("Location Name",'pixomi'),
	            "description" => esc_html__("Enter Your Location Name Here",'pixomi'),
	            "param_name" => "location_name",
	            "type" => "textfield",
	            "class" => "",
	        ),

			array(
	            "heading" => esc_html__("Location Address",'pixomi'),
	            "description" => esc_html__("Enter Your Location Address Here",'pixomi'),
	            "param_name" => "location_address",
	            "type" => "textfield",
	            "class" => "",
	        ),

			array(
	            "heading" => esc_html__("Location Phone Number",'pixomi'),
	            "description" => esc_html__("Enter Your Location Phone Number Here",'pixomi'),
	            "param_name" => "location_phone",
	            "type" => "textfield",
	            "class" => "",
	        ),

			array(
	            "heading" => esc_html__("Location Email",'pixomi'),
	            "description" => esc_html__("Enter Your Location Email Here",'pixomi'),
	            "param_name" => "location_email",
	            "type" => "textfield",
	            "class" => "",
	        ),
		)
	) );
}
add_action( 'vc_before_init', 'pixomi_location_boxes_vc_map' );
