<?php
function pixomi_page_metaboxes() {
	$prefix = 'pixomi_';

	/* =========================================================== */
	/* 00. Page Layout 
	/* =========================================================== */
	$cmb_layout = new_cmb2_box( array(
		'id'            => $prefix . 'page_layout',
		'title'         => esc_html__( 'Page Layout', 'pixomi' ),
		'object_types'  => array( 'page' ),
		'context'    => 'side',
		'priority'   => 'default',
		'show_names' => true,
	) );

	$cmb_layout->add_field( array(
		'name'             => esc_html__( 'Select Page Layout', 'pixomi' ),
		'id'               => $prefix . 'page_layout',
		'type'             => 'select',
		'show_option_none' => false,
		'options' => array(
			'default' 		=> esc_html__( 'Page : Default No Sidebar', 'pixomi' ),
			'right-sidebar' => esc_html__( 'Page : Right Sidebar', 'pixomi' ),
			'left-sidebar'  => esc_html__( 'Page : Left Sidebar', 'pixomi' ),
			'fullwidth'     => esc_html__( 'Page : FullWidth', 'pixomi' ),
		),
		'default'  => '',
	) );

	/* =========================================================== */
	/* 00. Portfolio Layout 
	/* =========================================================== */
	$cmb_layout = new_cmb2_box( array(
		'id'            => $prefix . 'portfolio_layout',
		'title'         => esc_html__( 'Portfolio Page Layout', 'pixomi' ),
		'object_types'  => array( 'portfolio' ),
		'context'    => 'side',
		'priority'   => 'default',
		'show_names' => true,
	) );

	$cmb_layout->add_field( array(
		'name'             => esc_html__( 'Select Portfolio page Layout', 'pixomi' ),
		'id'               => $prefix . 'portfolio_layout',
		'type'             => 'select',
		'show_option_none' => false,
		'options' => array(
			'default' 		=> esc_html__( 'Portfolio : Default No Sidebar', 'pixomi' ),
			'right-sidebar' => esc_html__( 'Portfolio : Right Sidebar', 'pixomi' ),
			'left-sidebar'  => esc_html__( 'Portfolio : Left Sidebar', 'pixomi' ),
			'fullwidth'     => esc_html__( 'Portfolio : FullWidth', 'pixomi' ),
		),
		'default'  => '',
	) );
	
	/* =========================================================== */
	/* 00. Slider and Header 
	/* =========================================================== */
	$cmb_slider = new_cmb2_box( array(
		'id'            => $prefix . 'page_slider_option',
		'title'         => esc_html__( 'Page Settings', 'pixomi' ),
		'object_types'  => array( 'page' ),
		'context'    => 'normal',
		'priority'   => 'default',
		'show_names' => true,
	) );

	// Header Layout
	$cmb_slider->add_field( array(
		'name'             => esc_html__( 'Header Layout', 'pixomi' ),
		'desc' 	  		 => esc_html__( 'Select Your Desired Header Layout You can view Header Layout from Admin Panel in Header Section.', 'pixomi' ),
		'id'               => $prefix . 'header_layout',
		'type'             => 'select',
		'show_option_none' => false,
		'options' => array(
			''    => esc_html__( 'Inherit From Theme Options', 'pixomi' ),
			'1'   => esc_html__( 'Header v1 Classic', 'pixomi' ),
			'2'   => esc_html__( 'Header v2 Modern Transparent', 'pixomi' ),
			'3'   => esc_html__( 'Header v3 Logo Center Transparent', 'pixomi' ),
			'4'   => esc_html__( 'Header v4 Fixed Vertical', 'pixomi' ),
			'5'   => esc_html__( 'No Header', 'pixomi' ),
		),
		'default'  => '',
	) );

	// Page Slider
	$cmb_slider->add_field( array(
		'name'             => esc_html__( 'Enable Page Slider', 'pixomi' ),
		'desc' 	  		   => esc_html__( 'Enable or Disable Page Slider.', 'pixomi' ),
		'id'               => $prefix . 'enable_slider',
		'type'             => 'select',
		'show_option_none' => false,
		'options' => array(
			'' 		 => esc_html__( 'No', 'pixomi' ),
			'yes'    => esc_html__( 'Yes', 'pixomi' ),
		),
		'default'  => '',
	) );

	// Revolution Slider
	$cmb_slider->add_field( array(
		'name'             => esc_html__( 'Choose Revolution Slider', 'pixomi' ),
		'desc' 	  		   => esc_html__( 'Only Accessible When Page Slider is Yes', 'pixomi' ),
		'id'               => $prefix . 'rev_slider_type',
		'type'             => 'select',
		'show_option_none' => false,
		'options' => pixomi_get_rev_sliders(),
		'default'  => '',
	) );

	/* =========================================================== */
	/* 00. Titlebar 
	/* =========================================================== */
	$cmb_titlebar = new_cmb2_box( array(
		'id'            => $prefix . 'page_titlebar_options',
		'title'         => esc_html__( 'Page Titlebar Settings', 'pixomi' ),
		'object_types'  => array( 'page', 'portfolio', 'product' ),
		'context'    => 'normal',
		'priority'   => 'default',
		'show_names' => true,
	) );

	// Page Titlebar
	$cmb_titlebar->add_field( array(
		'name'             => esc_html__( 'Enable Page Titlebar ', 'pixomi' ),
		'desc' 	  		   => esc_html__( 'Enable or Disable Page Titlebar.', 'pixomi' ),
		'id'               => $prefix . 'enable_titlebar',
		'type'             => 'select',
		'show_option_none' => false,
		'options' => array(
			'yes' 		 => esc_html__( 'Yes', 'pixomi' ),
			'no'         => esc_html__( 'No', 'pixomi' ),
		),
		'default'  => 'yes',

	) );

	// Titlebar Bg Image
	$cmb_titlebar->add_field( array(
		'name' 	  => esc_html__( 'Titlebar Background Image', 'pixomi' ),
		'desc' 	  => esc_html__( 'Choose Your Desired Background Image Instead of Default Image', 'pixomi' ),
	    'id' 	  => $prefix . 'titlebar_bg_img',
	    'type' 	  => 'file',
	    'options' => array(
		'url' => false, 
		),
	    'default' => get_template_directory_uri().'/images/bg.jpg',
	) );
}
add_action( 'cmb2_admin_init', 'pixomi_page_metaboxes' );