<?php

// Register Widget
function pixomi_register_recent_posts_widget() {
    register_widget( 'Pixomi_Recent_Posts_widget' );
}

add_action( 'widgets_init', 'pixomi_register_recent_posts_widget' );

// Extend Widget Class
if ( ! class_exists( 'Pixomi_Recent_Posts_widget' ) ){

	class Pixomi_Recent_Posts_widget extends WP_Widget {

		// Construct Widget
		function __construct() {
			$widget_ops	 = array( 'classname' => 'image-post-widget', 'description' => esc_html__('Show Post With Images.', 'pixomi_core') );
			$control_ops = array( 'id_base' => 'pixomi_widget_image_post' );
			parent::__construct( 'pixomi_widget_image_post', esc_html__('Pixomi : Recent Posts With Images', 'pixomi_core'), $widget_ops, $control_ops );
		}

		// Output Widget
		function widget( $args, $instance ) {
			extract( $args );
			
			$defaults	 = array( 'title' => esc_html__( 'Popular Posts', 'pixomi_core' ), 'no_of_posts' => '6', 'posts_order' => 'latest', 'thumb' => 'true' );
			$instance	 = wp_parse_args( (array) $instance, $defaults );

			$title		 = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );
			$no_of_posts = $instance[ 'no_of_posts' ];
			$posts_order = $instance[ 'posts_order' ];
			$thumb		 = $instance[ 'thumb' ];

			echo $before_widget;
			if ( !empty( $title ) ) {
				echo $before_title;
				echo $title;
				echo $after_title;
			} ?>
			<ul>
				<?php
				if ( $posts_order == 'popular' )
					$this->wp_popular_posts( $no_of_posts, $thumb );

				elseif ( $posts_order == 'random' )
					$this->wp_random_posts( $no_of_posts, $thumb );
				else
					$this->wp_last_posts( $no_of_posts, $thumb )
					?>	
			</ul>
			<?php echo $after_widget;
		}

		// Update Widget
		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;

			$instance[ 'title' ]		 = sanitize_text_field( $new_instance[ 'title' ] );
			$instance[ 'no_of_posts' ]	 = absint( $new_instance[ 'no_of_posts' ] );
			$instance[ 'posts_order' ]	 = (in_array( $new_instance[ 'posts_order' ], array( 'latest', 'popular', 'random' ) )) ? $new_instance[ 'posts_order' ] : 'latest';
			$instance[ 'thumb' ]		 = isset( $new_instance[ 'thumb' ] );
			return $instance;
		}

		// Widget Form
		function form( $instance ) {
			$defaults	 = array( 'title' => esc_html__( 'Popular Posts', 'pixomi_core' ), 'no_of_posts' => '6', 'posts_order' => 'latest', 'thumb' => 'true' );
			$instance	 = wp_parse_args( (array) $instance, $defaults );
			?>

			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Widget Title :', 'pixomi_core' ); ?></label>
				<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'no_of_posts' ); ?>"><?php esc_html_e( 'Number of Posts to Show :', 'pixomi_core' ); ?></label>
				<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'no_of_posts' ); ?>" name="<?php echo $this->get_field_name( 'no_of_posts' ); ?>" value="<?php echo $instance[ 'no_of_posts' ]; ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'posts_order' ); ?>"><?php esc_html_e( 'Post Order :', 'pixomi_core' ); ?></label>
				<select  class="widefat" id="<?php echo $this->get_field_id( 'posts_order' ); ?>" name="<?php echo $this->get_field_name( 'posts_order' ); ?>" >
					<!-- Latest Posts -->
					<option value="latest" 
					<?php if ( $instance[ 'posts_order' ] == 'latest' )
						echo "selected=\"selected\"";
					else echo ""; ?>>
					<?php esc_html_e( 'Recent Posts', 'pixomi_core' ); ?>
					</option>
					<!-- Random Posts -->
					<option value="random" 
					<?php if ( $instance[ 'posts_order' ] == 'random' )
						echo "selected=\"selected\"";
					else
						echo ""; ?>>
					<?php esc_html_e( 'Random Posts', 'pixomi_core' ); ?>
					</option>
					<!-- Popular Posts -->
					<option value="popular" 
					<?php if ( $instance[ 'posts_order' ] == 'popular' )
						echo "selected=\"selected\"";
					else
						echo ""; ?>>
					<?php esc_html_e( 'Popular Posts', 'pixomi_core' ); ?>
					</option>
				</select>
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'thumb' ); ?>"><?php esc_html_e( 'Display Image Thumbnails :', 'pixomi_core' ); ?></label>
				<input id="<?php echo $this->get_field_id( 'thumb' ); ?>" name="<?php echo $this->get_field_name( 'thumb' ); ?>" value="true" <?php if ( $instance[ 'thumb' ] ) echo 'checked="checked"'; ?> type="checkbox" />
			</p>

			<?php
		}

		// Output Popular Blog Posts
		function wp_popular_posts( $pop_posts = 5, $thumb = true ) {
			global $wpdb, $post;
			$orig_post = $post;

			$popularposts = get_posts( 'orderby=comment_count&numberposts=' . $pop_posts );
			foreach ( $popularposts as $post ): setup_postdata( $post );
				?>
				<li <?php echo ($thumb ? 'class="thumb"' : ''); ?> >
					<?php if ( function_exists( "has_post_thumbnail" ) && has_post_thumbnail() && $thumb ) : ?>			
					<div class="post-thumb">
						<a href="<?php the_permalink(); ?>" title="<?php printf( __( 'Permalink to %s', 'pixomi_core' ), the_title_attribute( 'echo=0' ) ); ?>"><?php the_post_thumbnail( 'pixomi-widget-post-thumb' ); ?></a>
					</div>
					<?php endif; ?>
					<div class="widget-post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
					<small class="widget-post-date"><?php echo get_the_date(); ?></small>
				</li>
				<?php endforeach;
			$post = $orig_post;
		}

		// Output Recent Blog Posts
		function wp_last_posts( $numberOfPosts = 5, $thumb = true ) {
			global $post;
			$orig_post = $post;

			$lastPosts = get_posts( 'numberposts=' . $numberOfPosts );
			foreach ( $lastPosts as $post ): setup_postdata( $post ); ?>
				<li <?php echo ($thumb ? 'class="thumb"' : ''); ?> >
					<?php if ( function_exists( "has_post_thumbnail" ) && has_post_thumbnail() && $thumb ) : ?>			
					<div class="widget-post">
						<a href="<?php the_permalink(); ?>" title="<?php printf( __( 'Permalink to %s', 'pixomi_core' ), the_title_attribute( 'echo=0' ) ); ?>"><?php the_post_thumbnail( 'pixomi-widget-post-thumb' ); ?></a>
					</div>
					<?php endif; ?>
					<div class="widget-post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
					<small class="widget-post-date"><?php echo get_the_date(); ?></small>
				</li>
			<?php endforeach;
			$post = $orig_post;
		}

		// Output Random Blog Posts
		function wp_random_posts( $numberOfPosts = 5, $thumb = true ) {
			global $post;
			$orig_post = $post;

			$lastPosts = get_posts( 'orderby=rand&numberposts=' . $numberOfPosts );
			foreach ( $lastPosts as $post ): setup_postdata( $post ); ?>
				<li <?php echo ($thumb ? 'class="thumb"' : ''); ?> >
					<?php if ( function_exists( "has_post_thumbnail" ) && has_post_thumbnail() && $thumb ) : ?>			
					<div class="widget-post">
						<a href="<?php the_permalink(); ?>" title="<?php printf( __( 'Permalink to %s', 'pixomi_core' ), the_title_attribute( 'echo=0' ) ); ?>"><?php the_post_thumbnail( 'pixomi-widget-post-thumb' ); ?></a>
					</div>
					<?php endif; ?>
					<div class="widget-post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
					<small class="widget-post-date"><?php echo get_the_date(); ?></small>
				</li>
			<?php endforeach;
			$post = $orig_post;
		}

	}
}

