<?php

/* =========================================================== */
/* 00. Project Post Type
/* =========================================================== */
function pixomi_register_portfolio_post_type() {  

	global $pixomi_data;
	$portfolio_slug = 'portfolio';
	
	$labels = array(
		'name' 				 => esc_html__( 'Portfolio', 'pixomi_core' ),
		'singular_name' 	 => esc_html__( 'Portfolio', 'pixomi_core' ),
		'add_new' 			 => esc_html__( 'Add New', 'pixomi_core' ),
		'add_new_item' 		 => esc_html__( 'Add New Portfolio', 'pixomi_core' ),
		'edit_item' 		 => esc_html__( 'Edit Portfolio', 'pixomi_core' ),
		'new_item' 			 => esc_html__( 'Add New Portfolio', 'pixomi_core' ),
		'view_item' 		 => esc_html__( 'View Portfolio', 'pixomi_core' ),
		'search_items' 		 => esc_html__( 'Search Portfolio', 'pixomi_core' ),
		'not_found' 		 => esc_html__( 'No portfolio found', 'pixomi_core' ),
		'not_found_in_trash' => esc_html__( 'No portfolio found in trash', 'pixomi_core' )
	);
	
	// Arguments
    $args = array(  
        'labels' 			=> $labels,
        'public' 			=> true,  
        'show_ui' 			=> true,  
        'capability_type' 	=> 'post',  
        'hierarchical' 		=> false,  
        'menu_icon' 		=> 'dashicons-portfolio',
        'rewrite' 			=> array('slug' => $portfolio_slug), 
        'supports' 			=> array('title', 'editor', 'thumbnail', 'comments', 'excerpt')  
       );  
  
    register_post_type( 'portfolio' , $args );  
}
add_action('init', 'pixomi_register_portfolio_post_type', 1);   

/* =========================================================== */
/* 00. Portfolio Taxonomy
/* =========================================================== */
function pixomi_register_portfolio_taxonomy() {
	
	register_taxonomy("portfolio_filter", array("portfolio"), 
		array("hierarchical" => true, 
			"label" => "Portfolio Filter", 
			"singular_label" => "Portfolio Filter", 
			"rewrite" => true
		));
}
add_action('init', 'pixomi_register_portfolio_taxonomy', 1);   

/* =========================================================== */
/* 00. Portfolio Shortcode
/* =========================================================== */
if (!function_exists('pixomi_portfolio_shortcode')) {
	function pixomi_portfolio_shortcode($atts){
		extract(shortcode_atts(array(
			'style' 		=> '1', 	
			'projects'      => '6',
			'columns' 		=> '3',
			'showfilter' 	=> 'yes',
			'filters' 		=> 'all',
			'pagination' 	=> 'no'
		), $atts));
		
		global $wp_query, $post, $paged;

		// Get Query Variable
		if ( get_query_var('paged') ) { $paged = get_query_var('paged'); 
		} elseif ( get_query_var('page') ) { $paged = get_query_var('page'); 
		} else { $paged = 1; }

		// Arguments
		$args = array(
			'post_type' 	 => 'portfolio',
			'posts_per_page' => intval($projects),
			'order'          => 'DESC',
			'orderby'        => 'date',
			'post_status'    => 'publish',
			'paged' 		 => $paged
		);
		
		// Filters
		if($filters != 'all' && $filters != ''){
			$str = $filters;
			$arr = explode(',', $str);
			$args['tax_query'][] = array(
				'taxonomy'  => 'portfolio_filter',
				'field'   => 'slug',
				'terms'   => $arr
			);
		}

		query_posts($args);

		ob_start(); // Obj Start

		if( $wp_query->have_posts() ) :
			
		$randomnumber = rand(); ?>

		<div class="portfolio-container">
		 
		 	<!-- Portfolio Filter -->
			<?php if($showfilter == 'yes'){ 
				if($filters != '' && $filters != 'all') {
					$portfolio_filters = explode(',', $filters);
				} else {
					$portfolio_filters = get_terms('portfolio_filter');
					$arraytostring = '';
					foreach($portfolio_filters as $portfolio_filter){
						$arraytostring .= $portfolio_filter->slug . ',';
					}
					$arraytostring = rtrim($arraytostring,','); // Remove last commata;
					$portfolio_filters = explode(',', $arraytostring); // Create array
				} ?>

				<div class="portfolio-filters" data-id="<?php echo intval($randomnumber); ?>">
					<?php if($portfolio_filters): ?>
						<span><a href="#" data-filter="*" class="filter-all active"><?php esc_html_e('All', 'pixomi_core'); ?></a></span>	
						<?php foreach($portfolio_filters as $portfolio_filter => $value){ ?>
							<?php $filter_name = get_term_by('slug',$value,'portfolio_filter'); ?>
							<span><a href="#" data-filter=".term-<?php echo esc_attr($value); ?>"><?php echo esc_html($filter_name->name); ?></a></span>
						<?php } ?>
					<?php endif; ?>
				</div>
			<?php } ?>

			<!-- Portfolio -->
			<div id="<?php echo intval($randomnumber); ?>" class="portfolio-items" data-id="<?php echo intval($randomnumber); ?>">  
				<?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>

					<!-- Columns -->
					<?php if($columns == '3'){
						$column_output = 'col-lg-4 col-md-4 col-sm-6 col-xs-12';
					} elseif($columns == '4') {
						$column_output = 'col-lg-3 col-md-3 col-sm-6 col-xs-12';
					} ?>

					<!-- Style 1 -->
					<?php if($style == '1'){ ?>
						<?php if ( has_post_thumbnail()) { $portfolio_thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'portfolio' ); } ?>
						<?php $terms = get_the_terms( get_the_ID(), 'portfolio_filter' ); ?>
						<?php $category_list  = wp_get_post_terms( get_the_ID(), 'portfolio_filter' ); ?>   
						<div class="<?php if($terms) : foreach ($terms as $term) { echo 'term-'.esc_attr($term->slug).' '; } endif; ?>portfolio-item portfolio-style-1 <?php echo esc_attr($column_output); ?>">
							<?php echo '<a class="entry-overlay" href="'. esc_url(get_permalink()) .'" title="'.esc_attr(get_the_title()).'">'; ?><div class="portfolio-image"><img src="<?php echo esc_url($portfolio_thumbnail[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" /></div></a>
							<div class="portfolio-content">
								<div class="portfolio-category"><?php echo esc_html( $category_list[0]->name ); ?></div>
								<h3><a href="<?php echo the_permalink(); ?>" title="<?php the_title() ?>"><?php the_title() ?></a></h3>
							</div>
						</div>
						
					<!-- Style 2 -->
					<?php } elseif($style == '2'){ ?>
						<?php if ( has_post_thumbnail()) { $portfolio_thumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'portfolio' ); } ?>
						<?php $terms = get_the_terms( get_the_ID(), 'portfolio_filter' ); ?>
						<?php $category_list  = wp_get_post_terms( get_the_ID(), 'portfolio_filter' ); ?>   
						<div class="<?php if($terms) : foreach ($terms as $term) { echo 'term-'.esc_attr($term->slug).' '; } endif; ?> portfolio-item portfolio-style-2 <?php echo esc_attr($column_output); ?>">
							<?php echo '<a href="'. esc_url(get_permalink()) .'" title="'.esc_attr(get_the_title()).'">'; ?><img src="<?php echo esc_url($portfolio_thumbnail[0]); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" /></a>
							<div class="portfolio-style-2-content">
								<ul class="portfolio-style-2-cat">
									<li><?php echo esc_html( $category_list[0]->name ); ?></li>
								</ul>
								<h3><a href="<?php echo the_permalink(); ?>" title="<?php the_title() ?>"><?php the_title() ?></a></h3>
							</div>
						</div>
					<?php } ?>

				<?php endwhile; ?>
			</div>
			<!-- Portfolio End -->

		</div>
		
		<!-- Pagination -->
		<?php if($pagination == 'yes'){ ?>
			<?php pixomi_pagination(); ?>
		<?php } ?>

		<?php wp_reset_query(); endif; 

		$portfolio_output = ob_get_contents(); 
		ob_end_clean(); 

		return $portfolio_output;
	
	}
	add_shortcode('pixomi_portfolio', 'pixomi_portfolio_shortcode');
}

/* =========================================================== */
/* 00. Map to vc - Portfolio
/* =========================================================== */
if (!function_exists('is_plugin_active')){ include_once( ABSPATH . 'wp-admin/includes/plugin.php' ); } 
if(is_plugin_active('pixomi_core/pixomi_core.php')){ 

	function pixomi_portfolio_vc_map() {

		// Get Portfolio Filter
		$portfolio_options = NULL;
		$portfolio_filters = get_terms('portfolio_filter');
		foreach ($portfolio_filters as $filter) { $portfolio_options[$filter->name] = $filter->slug; }

		vc_map( array(
			"name"					=> esc_html__( "Portfolio", 'pixomi_core' ),
			"description"			=> esc_html__( "Show your Projects Portfolios", 'pixomi_core' ),
			"base"					=> "pixomi_portfolio",
			'category'				=> "Pixomi",
			"icon"      			=> plugin_dir_url(__DIR__) . "/img/vc_portfolio.png",
			"params"				=> array(
				
				// Portfolio Layout Style
				array(
					"heading"		=> esc_html__( "Portfolio Style", 'pixomi_core' ),
					"description"	=> esc_html__( "Select Your Prefered Portfolio Style", 'pixomi_core' ),
					"param_name"	=> "style",
					"type"			=> "dropdown",
					"admin_label"	=> true,
					"class"			=> "",
					"value"			=> array(
						esc_html__('Portfolio Style 1', 'pixomi_core') 	 => '1',
						esc_html__('Portfolio Style 2', 'pixomi_core') 	 => '2',
					)
				),

				// Portfolio Column Layout
				array(
					"heading"		=> esc_html__( "Portfolio Columns", 'pixomi_core' ),
					"description"	=> esc_html__( "Choose Your Prefered Columns.", 'pixomi_core' ),
					"param_name"	=> "columns",
					"type"			=> "dropdown",
					"admin_label"	=> false,
					"class"			=> "",
					"value"			=> array(
						esc_html__('3 Columns', 'pixomi_core')  => '3',
						esc_html__('4 Columns', 'pixomi_core')  => '4',
					),
				),

				// Number of Projects
				array(
					"heading"		=> esc_html__( "Number of Projects", 'pixomi_core' ),
					"description"	=> __( "Type How Many Projects you want to show. Enter <strong>-1</strong> to show all Projects.", 'pixomi_core' ),
					"param_name"	=> "projects",
					"type"			=> "textfield",
					"admin_label"	=> true,
					"class"			=> "",
					"value"			=> "6",
				),

				// Enable Filter
				array(
					"heading"		=> esc_html__( "Show Portfolio Filter", 'pixomi_core' ),
					"description"	=> esc_html__( "Show or Hide Portfolio Filter.", 'pixomi_core' ),
					"type"			=> "dropdown",
					"admin_label"	=> false,
					"class"			=> "",
					"param_name"	=> "showfilter",
					"value"			=> array(
						esc_html__('Yes', 'pixomi_core')  => 'yes',
						esc_html__('No', 'pixomi_core')  => 'no',
					),
				),

				// Choose Filter
				array(
					"heading"		=> esc_html__( "Choose Portfolio Filter", 'pixomi_core' ),
					"description"	=> __( "If no Filter is Selected Then It will show Items from <strong>ALL</strong> filters.", 'pixomi_core' ),
					"type"			=> "checkbox",
					"admin_label"	=> false,
					"class"			=> "",
					"param_name"	=> "filters",
					"value"			=> $portfolio_options,
				),

				// Pagination
				array(
					"heading"		=> esc_html__( "Enable Pagination", 'pixomi_core' ),
					"description"	=> esc_html__( "If your Projects are Most Numbers we Recommed you to Divide them with Pagination.", 'pixomi_core' ),
					"type"			=> "dropdown",
					"admin_label"	=> false,
					"class"			=> "",
					"param_name"	=> "pagination",
					"value"			=> array(
						esc_html__('No', 'pixomi_core')  => 'no',
						esc_html__('Yes', 'pixomi_core')  => 'yes',
					),
				),
			)
		) );
	}
	add_action( 'vc_before_init', 'pixomi_portfolio_vc_map' );
}

