const slugify = ( str ) =>
	str
		.toLowerCase()
		.trim()
		.replace( /[^\w\s-]/g, '' )
		.replace( /[\s_-]+/g, '-' )
		.replace( /^-+|-+$/g, '' );
const functionify = ( str ) => {
	str = slugify( str );
	return str.replace( /-/g, '_' );
};

const title = 'Gutenify';
const prefix = 'gutenify';
const slug = `${ slugify( prefix ) }`;
const functionPrefix = `${ functionify( prefix ) }_`;
const authorWebSite = `https://${ slugify( prefix ) }.com`;
const authorDemoWebSite = `https://demo.${ slugify( prefix ) }.com`;
const authorWebSiteProPage = `${ authorWebSite }/pricing`;
const authorWebSiteSupport = `${ authorWebSite }/product-support`;
const defaultTheme = {
	slug: `gutenify-base`,
	title: `Gutenify Base`,
};

const {
	is_pro_activated: isProActivated,
	pro_account_url: proAccountUrl,
	site_url: siteUrl,
	pro_license_status: proLicenseStatus,
} = window?.[ `_${ functionPrefix }vars` ];

export {
	title as appTitle,
	prefix as appPrefix,
	slug as appSlug,
	functionPrefix as appFunctionPrefix,
	authorWebSite as appAuthorWebSite,
	authorDemoWebSite as appAuthorDemoWebSite,
	authorWebSiteProPage as appauthorWebSiteProPage,
	defaultTheme as appDefaultTheme,
	siteUrl as appSiteUrl,
	authorWebSiteSupport as appAuthorWebSiteSupport,

	// Pro
	isProActivated as isAppProActivated,
	proAccountUrl as appProAccountUrl,
	proLicenseStatus as appProLicenseStatus,
};
