<?php 

global $pixomi_data;
$pixomi_data = get_option('pixomi_data'); //IMPORTANT

/* =========================================================== */
/* 00. Woo General 
/* =========================================================== */
// Remove Default Styles
add_filter( 'woocommerce_enqueue_styles', '__return_false' );

// Remove Page title
add_filter( 'woocommerce_show_page_title', '__return_false' );

// Change products per page
function pixomi_products_per_page( $cols ) {
    global $pixomi_data;
    $woo_product_numbers = isset($pixomi_data["woo_product_numbers"]) ? $pixomi_data["woo_product_numbers"] : '';
    if($woo_product_numbers != "") {
        $cols = $woo_product_numbers;
    }else { $cols = 6; }
  return $cols;
}
add_filter( 'loop_shop_per_page', 'pixomi_products_per_page', 20 );

/* =========================================================== */
/* 00. Woo Product Image Size 
/* =========================================================== */
function pixomi_product_image_size( $size ) {
    $size = array(
        'width'  => '400',
        'height' => '620',
        'crop'   => 1
    );
    return $size;
}
add_filter( 'woocommerce_get_image_size_shop_catalog', 'pixomi_product_image_size', 10, 1 );

/* =========================================================== */
/* 00. Woo Single Product Image Size 
/* =========================================================== */
function pixomi_single_product_image_size( $size ) {
    $size = array(
        'width'  => '400',
        'height' => '620',
        'crop'   => 1
    );
    return $size;
}
add_filter( 'woocommerce_get_image_size_shop_single', 'pixomi_single_product_image_size', 10, 1 );

/* =========================================================== */
/* 00. Woo Single Product Thumbnail Size 
/* =========================================================== */
function pixomi_single_product_thumbnails_size( $size ) {
    $size = array(
        'width'  => '90',
        'height' => '90',
        'crop'   => 1
    );
    return $size;
}
add_filter( 'woocommerce_get_image_size_shop_thumbnail', 'pixomi_single_product_thumbnails_size', 10, 1 );

/* =========================================================== */
/* 00. Woo Pagination 
/* =========================================================== */
function woocommerce_pagination() {
    pixomi_pagination();         
}
add_action( 'woocommerce_pagination', 'woocommerce_pagination', 10);
remove_action('woocommerce_pagination', 'woocommerce_pagination', 10);

/* =========================================================== */
/* 00. Woo Search Form 
/* =========================================================== */
function pixomi_get_product_search_form() {
    return  '<form role="search" method="get" class="search-form" action="' . esc_url( home_url( '/' ) ) . '">
                <input type="search" class="search-field" value="' . get_search_query() . '" placeholder="' . esc_html__( 'Search products..', 'pixomi' ) . '" />
                <button type="submit" class="product-search-submit"><i class="fa fa-search"></i></button>
            </form>';
}
add_filter( 'get_product_search_form', 'pixomi_get_product_search_form', 10 );

/* =========================================================== */
/* 00. Woo Breadcrumbs 
/* =========================================================== */
function pixomi_woocommerce_breadcrumb() {
    return array(
        'delimiter'   => '<span class="delimiter">&raquo;</span>',
        'wrap_before' => '',
        'wrap_after'  => '',
        'before'      => '<span>',
        'after'       => '</span>',
        'home'        => '',
    );
}
add_filter( 'woocommerce_breadcrumb_defaults', 'pixomi_woocommerce_breadcrumb', 10 );
