<?php global $pixomi_data; 

$header_phone    = isset( $pixomi_data[ 'header_phone' ] ) ? $pixomi_data[ 'header_phone' ] : '';
$header_email    = isset( $pixomi_data[ 'header_email' ] ) ? $pixomi_data[ 'header_email' ] : '';
$header_address  = isset( $pixomi_data[ 'header_address' ] ) ? $pixomi_data[ 'header_address' ] : '';

get_template_part('functions/headers/header-topbar'); ?>
<div id="header" class="header header-v5">
    <div class="logo-block">
		<div class="container">
           <div class="row">
                <div class="col-md-12"> 
			        <div id="logo" class="logo">
			            <?php if(isset($pixomi_data['theme_logo']['url']) && ($pixomi_data['theme_logo']['url'] != "")) { ?>
			                <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url($pixomi_data['theme_logo']['url']); ?>" alt="<?php echo esc_attr(bloginfo('name')); ?>" ></a>
			            <?php } else { ?>
			                <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><h2><?php esc_html(bloginfo('name')); ?></h2></a>
			            <?php } ?>
			        </div>
					<div class="info">
						<?php if($header_phone != "") { ?>
							<div class="info-box">
			                    <div class="info-box-icon">
			                        <i class="droplet-old-telephone"></i>
			                    </div>
			                    <div class="info-box-content">
			                        <h6><?php esc_html_e( 'Phone Number', 'pixomi' ); ?></h6>
			                        <p><?php echo wp_kses_post($header_phone); ?></p>
			                    </div>
			                </div>
			            <?php } ?>
						<?php if($header_email != "") { ?>
							<div class="info-box">
			                    <div class="info-box-icon">
			                        <i class="droplet-email"></i>
			                    </div>
			                    <div class="info-box-content">
			                        <h6><?php esc_html_e( 'Email Address', 'pixomi' ); ?></h6>
			                        <p><?php echo wp_kses_post($header_email); ?></p>
			                    </div>
			                </div>
			            <?php } ?>
						<?php if($header_address != "") { ?>
							<div class="info-box">
			                    <div class="info-box-icon">
			                        <i class="droplet-map-location"></i>
			                    </div>
			                    <div class="info-box-content">
			                        <h6><?php esc_html_e( 'Address', 'pixomi' ); ?></h6>
			                        <p><?php echo wp_kses_post($header_address); ?></p>
			                    </div>
			                </div>
			            <?php } ?>
					</div>
        		</div>
    		</div>
        </div>
    </div>
	<div class="nav-block">
		<div class="container">
	        <div class="row">
	            <div class="col-md-12">
					<div id="navigation">
						<?php if(has_nav_menu('pixomi-primary_menu')) {
							wp_nav_menu( array(
								'theme_location' => 'pixomi-primary_menu',
								'container' 	 => false,
								'menu_class'	 => 'sf-menu main-menu',
								'depth'			 => 0,
							) ); 
						} ?> 
	        		</div>
	    		</div>
	        </div>
	    </div>
    </div>
</div>
<?php get_template_part('functions/headers/mobile-header'); ?>
