<x-app-layout>
<main id="main" class="main">

<div class="pagetitle">
  <h1>General Tables</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{route('niveaux.index')}}">Table de bord</a></li>
      <li class="breadcrumb-item">Tables</li>
      <li class="breadcrumb-item active">General</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section">
@if ($errors->has('delete_error'))
    <div class="alert alert-danger">
    <i class="ri-alert-fill"></i> {{ $errors->first('delete_error') }}
    </div>
@endif
@if(session('success'))
    <div class="alert alert-success">
      <i class="ri-alert-fill"></i> {{ session('success') }}
    </div>
@endif
  
  <div class="row">
    <div class="col-lg-4">
        <div class="form-group">
            <input type="search" id="myInput" class="form-control" placeholder="Search ..." onkeyup="myFunction()">
        </div>
    </div>

    <div class="col-auto text-end float-end ms-auto download-grp">
        
        <a href="{{route('provinces.create')}}" class="btn btn-primary"><i class="bi bi-plus"></i> Nouvelle Province</a>
    </div>
    
  </div><br>
  
  <div class="row">
    <div class="col-lg-12">

      

      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Liste des provinces</h5>

          <!-- Table with hoverable rows -->
          <table class="table table-hover">
            <thead>
              <tr>
                <th scope="col">#</th>
                <th scope="col">Nom</th>
                <th colspan="2">Actions</th>
              </tr>
            </thead>
            <tbody id="myTable">
            @foreach($provinces as $province)
              <tr>
                <td>{{$province->id}}</td>
                <th scope="row">{{$province->nom}}</th>
                <td> 
                  <div>
                    <a href="{{ route('provinces.edit', $province->id) }}" class="badge bg-warning"><i class="bi bi-pencil-square"></i></a></td>
                          <td>
                          <form action="{{route('provinces.destroy', $province->id)}}" method="POST">
                            @csrf
                            @method('DELETE')
                          <button type="submit" class="badge bg-danger"><i class="bi bi-trash-fill"></i></button>
                          </form>
                  </div>
                </td>
              </tr>
            @endforeach
            </tbody>
          </table>
          <!-- End Table with hoverable rows -->

        </div>
      </div>

      

    </div>
  </div>
</section>

</main>
</x-app-layout>