<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dossiers', function (Blueprint $table) {
            $table->id();
            $table->string('numero')->unique();

            $table->unsignedBigInteger('niveau_id');
            $table->foreign('niveau_id')->references('id')->on('niveau')->onUpdate('cascade')->onDelete('cascade');
            
            $table->unsignedBigInteger('etat_id');
            $table->foreign('etat_id')->references('id')->on('etat_dossiers')->onUpdate('cascade')->onDelete('cascade');
            
            $table->unsignedBigInteger('type_dossier_id');
            $table->foreign('type_dossier_id')->references('id')->on('type_dossiers')->onUpdate('cascade')->onDelete('cascade');
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dossiers');
    }
};
