<?php

namespace App\Listeners;

use App\Events\DossierAjouterEvent;
use App\Notifications\DossierAjouterNotification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Models\User;

class DossierAjouterListener implements ShouldQueue
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    use InteractsWithQueue;

    /**
     * Handle the event.
     *
     * @param  \App\Events\DossierAjouterEvent  $event
     * @return void
     */
    public function handle(DossierAjouterEvent $event)
    {
        $presidents = User::join('roles', 'users.role_id', 'roles.id')
        ->where('roles.nom', '=', 'Président')->get();
        foreach($presidents as $president) {
            $president->notify(new DossierAjouterNotification($event->dossier));
        }
        
    }
}
