<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check()) {

            /** @var App\Models\User */
            $user = Auth::user();

            if($user->hasRole(['Admin', 'Président', 'Juge', 'Greffier', 'Greffier Caissier', 'Procureur', 'Secrétaire', 'OMP'])){
                return $next($request);
            }

            abort(403, "Vous n'avez pas le droit!");
            
        }
    
        abort(401);
    }
}
