<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\UtilisateurController;
use App\Http\Controllers\DossierController;
use App\Http\Controllers\FichiersController;
use App\Http\Controllers\NiveauController;
use App\Http\Controllers\TypeCategorieDossierController;
use App\Http\Controllers\TypeDossierController;
use App\Http\Controllers\TypeFichierController;
use App\Http\Controllers\EtatDossierController;
use App\Http\Controllers\JuridictionsController;
use App\Http\Controllers\JugementsController;
use App\Http\Controllers\AudiencesController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\JugeController;
use App\Http\Controllers\RepartirController;
use App\Http\Controllers\ProvinceController;
use App\Http\Controllers\CommuneController;
use App\Http\Controllers\ParquetController;
use App\Http\Controllers\TransfertDossierController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\CommentaireController;
use App\Http\Controllers\ValiderController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('auth/login');
});

Route::controller(DashboardController::class)->prefix('dashboard')->group(function() {
    Route::get('', 'index')->middleware('auth')->name('dashboard');
    
});

Route::controller(DashboardController::class)->prefix('dashboardParquet')->group(function() {
    Route::get('', 'dashbord')->middleware('auth')->name('dashboardParquet');
    
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::group(['middleware' => ['isAdmin']], function(){
Route::resource('permissions',PermissionController::class);
Route::get('permissions/{permissionId}/delete', [PermissionController::class, 'destroy']);

Route::resource('roles',RoleController::class);
Route::get('roles/{roleId}/delete', [RoleController::class, 'destroy']);
route::get('roles/{roleId}/give-permission', [RoleController::class, 'addPermissionToRole']);
route::put('roles/{roleId}/give-permission', [RoleController::class, 'givePermissionToRole']);

Route::resource('users',UtilisateurController::class);
Route::get('users/{userId}/delete', [UtilisateurController::class, 'destroy']);
});

Route::resource('dossiers',DossierController::class)->names([
    'index' => 'dossiers.index',
    'create' => 'dossiers.create',
    'store' => 'dossiers.store',
    'show' => 'dossiers.show',
    'edit' => 'dossiers.edit',
    'update' => 'dossiers.update',
    'destroy' => 'dossiers.destroy',
]);

Route::post('dossiers/valide/{dossier}', [DossierController::class, 'valide'])->name('dossiers.valide');
Route::post('dossiers/voir/{dossier}', [DossierController::class, 'voir'])->name('dossiers.voir');

Route::resource('niveaux',NiveauController::class)->names([
    'index' => 'niveaux.index',
    'create' => 'niveaux.create',
    'store' => 'niveaux.store',
    'show' => 'niveaux.show',
    'edit' => 'niveaux.edit',
    'update' => 'niveaux.update',
    'destroy' => 'niveaux.destroy',
]);

Route::resource('provinces',ProvinceController::class)->names([
    'index' => 'provinces.index',
    'create' => 'provinces.create',
    'store' => 'provinces.store',
    'show' => 'provinces.show',
    'edit' => 'provinces.edit',
    'update' => 'provinces.update',
    'destroy' => 'provinces.destroy',
]);

Route::resource('communes',CommuneController::class)->names([
    'index' => 'communes.index',
    'create' => 'communes.create',
    'store' => 'communes.store',
    'show' => 'communes.show',
    'edit' => 'communes.edit',
    'update' => 'communes.update',
    'destroy' => 'communes.destroy',
]);

Route::resource('parquets',ParquetController::class)->names([
    'index' => 'parquets.index',
    'create' => 'parquets.create',
    'store' => 'parquets.store',
    'show' => 'parquets.show',
    'edit' => 'parquets.edit',
    'update' => 'parquets.update',
    'destroy' => 'parquets.destroy',
]);

Route::resource('typeCategorieDossiers',TypeCategorieDossierController::class)->names([
    'index' => 'typeCategorieDossiers.index',
    'create' => 'typeCategorieDossiers.create',
    'store' => 'typeCategorieDossiers.store',
    'show' => 'typeCategorieDossiers.show',
    'edit' => 'typeCategorieDossiers.edit',
    'update' => 'typeCategorieDossiers.update',
    'destroy' => 'typeCategorieDossiers.destroy',
]);

Route::resource('typeDossiers',TypeDossierController::class)->names([
    'index' => 'typeDossiers.index',
    'create' => 'typeDossiers.create',
    'store' => 'typeDossiers.store',
    'show' => 'typeDossiers.show',
    'edit' => 'typeDossiers.edit',
    'update' => 'typeDossiers.update',
    'destroy' => 'typeDossiers.destroy',
]);

Route::resource('typefichiers',TypeFichierController::class)->names([
    'index' => 'typefichiers.index',
    'create' => 'typefichiers.create',
    'store' => 'typefichiers.store',
    'show' => 'typefichiers.show',
    'edit' => 'typefichiers.edit',
    'update' => 'typefichiers.update',
    'destroy' => 'typefichiers.destroy',
]);

Route::resource('fichiers',FichiersController::class)->names([
    'index' => 'fichiers.index',
    'create' => 'fichiers.create',
    'store' => 'fichiers.store',
    'show' => 'fichiers.show',
    'edit' => 'fichiers.edit',
    'update' => 'fichiers.update',
    'destroy' => 'fichiers.destroy',
]);

Route::get('fichiers/create/{dossier_id}', [FichiersController::class,'create'])->name('fichiers.create');

Route::resource('etatdossiers',EtatDossierController::class)->names([
    'index' => 'etatdossiers.index',
    'create' => 'etatdossiers.create',
    'store' => 'etatdossiers.store',
    'show' => 'etatdossiers.show',
    'edit' => 'etatdossiers.edit',
    'update' => 'etatdossiers.update',
    'destroy' => 'etatdossiers.destroy',
]);

Route::resource('juridictions',JuridictionsController::class)->names([
    'index' => 'juridictions.index',
    'create' => 'juridictions.create',
    'store' => 'juridictions.store',
    'show' => 'juridictions.show',
    'edit' => 'juridictions.edit',
    'update' => 'juridictions.update',
    'destroy' => 'juridictions.destroy',
]);

Route::resource('jugements',JugementsController::class)->names([
    'index' => 'jugements.index',
    'create' => 'jugements.create',
    'store' => 'jugements.store',
    'show' => 'jugements.show',
    'edit' => 'jugements.edit',
    'update' => 'jugements.update',
    'destroy' => 'jugements.destroy',
]);

Route::resource('audiences',AudiencesController::class)->names([
    'index' => 'audiences.index',
    'create' => 'audiences.create',
    'store' => 'audiences.store',
    'show' => 'audiences.show',
    'edit' => 'audiences.edit',
    'update' => 'audiences.update',
    'destroy' => 'audiences.destroy',
]);

Route::resource('affecters',JugeController::class)->names([
    'index' => 'affecters.index',
    'create' => 'affecters.create',
    'store' => 'affecters.store',
    'show' => 'affecters.show',
    'edit' => 'affecters.edit',
    'update' => 'affecters.update',
    'destroy' => 'affecters.destroy',
]);

Route::get('affecters/create/{dossier_id}', [JugeController::class,'create'])->name('affecters.create');

Route::resource('repartirs',RepartirController::class)->names([
    'index' => 'repartirs.index',
    'create' => 'repartirs.create',
    'store' => 'repartirs.store',
    'show' => 'repartirs.show',
    'edit' => 'repartirs.edit',
    'update' => 'repartirs.update',
    'destroy' => 'repartirs.destroy',
]);

Route::get('repartirs/create/{dossier_id}', [RepartirController::class,'create'])->name('repartirs.create');

Route::resource('validers',ValiderController::class)->names([
    'index' => 'validers.index',
    'create' => 'validers.create',
    'store' => 'validers.store',
    'show' => 'validers.show',
    'edit' => 'validers.edit',
    'update' => 'validers.update',
    'destroy' => 'validers.destroy',
]);

Route::get('validers/create/{commentaire_id}', [ValiderController::class,'create'])->name('validers.create');

Route::resource('commentaires',CommentaireController::class)->names([
    'index' => 'commentaires.index',
    'create' => 'commentaires.create',
    'store' => 'commentaires.store',
    'show' => 'commentaires.show',
    'edit' => 'commentaires.edit',
    'update' => 'commentaires.update',
    'destroy' => 'commentaires.destroy',
]);

Route::get('commentaires/create/{dossier_id}', [CommentaireController::class,'create'])->name('commentaires.create');

Route::resource('transferts',TransfertDossierController::class)->names([
    'index' => 'transferts.index',
    'create' => 'transferts.create',
    'store' => 'transferts.store',
    'show' => 'transferts.show',
    'edit' => 'transferts.edit',
    'update' => 'transferts.update',
    'destroy' => 'transferts.destroy',
]);

Route::get('transferts/create/{dossier_id}', [TransfertDossierController::class,'create'])->name('transferts.create');

// Route::resource('utilisateurs',UtilisateurController::class)->names([
//     'index' => 'utilisateurs.index',
//     'create' => 'utilisateurs.create',
//     'store' => 'utilisateurs.store',
//     'show' => 'utilisateurs.show',
//     'edit' => 'utilisateurs.edit',
//     'update' => 'utilisateurs.update',
//     'destroy' => 'utilisateurs.destroy',
// ]);

Route::post('/markAsRead/{notification}', function ($notificationId) {
    $notification = Auth::user()->notifications()->findOrFail($notificationId);
    $notification->markAsRead();

    return redirect()->back();
})->name('markAsRead');

Route::post('/markAllAsRead', function () {
    Auth::user()->unreadNotifications->markAsRead();

    return redirect()->back();
})->name('markAllAsRead');

require __DIR__.'/auth.php';
