<x-app-layout>


<main id="main" class="main">



<div class="pagetitle">
<h1 class="card-title">Les dossiers</h1>  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="#">Table de bord</a></li>
      <li class="breadcrumb-item">Tables</li>
      <li class="breadcrumb-item active">General</li>
    </ol>
  </nav>
</div>

<section class="section">
@if ($errors->has('delete_error'))
    <div class="alert alert-danger">
    <i class="ri-alert-fill"></i> {{ $errors->first('delete_error') }}
    </div>
@endif
@if(session('success'))
    <div class="alert alert-success">
      <i class="ri-alert-fill"></i> {{ session('success') }}
    </div>
@endif
  
  <div class="row">
    <div class="col-lg-4">
      <form method="GET" action="{{ route('dossiers.index') }}">
      <div class="form-group d-flex">
          <input type="search" name="search" class="form-control" placeholder="recherche ...">
          <button type="submit" class="badge bg-primary p-2 ms-2" title="Recherche"><i class="bi bi-search"></i></button>&nbsp;&nbsp;
          <a href="{{ route('dossiers.index') }}" class="btn btn-success" title="Actualiser"><i class="bi bi-arrow-repeat"></i></a>
      </div>
      </form>
    </div>



    <div class="col-auto text-end float-end ms-auto download-grp">
    
        @can('Create dossier')
        <a href="{{route('dossiers.create')}}" class="btn btn-primary"><i class="bi bi-plus"></i> Créer Dossier</a>
        @endcan
        @can('View transfert')
        <a href="{{route('transferts.index')}}" class="btn btn-success"><i class="bi bi-plus"></i> Voir les Transferts</a>
        @endcan

        @can('View affecter')
        <a href="{{route('affecters.index')}}" class="btn btn-primary"><i class="bi bi-plus"></i> Voir les affectations</a>
        @endcan

        @can('View repartir')
        <a href="{{route('repartirs.index')}}" class="btn btn-primary"><i class="bi bi-plus"></i> Voir répartition des dossiers</a>
        @endcan
    
    </div>

                   
    
  </div><br>
  
  <div class="row">
    <div class="col-lg-12">

      

      <div class="card">
        <div class="page-header">
            <div class="row align-items-center">
                <div class="col">
                    <center><h1 class="card-title">Tous les dossiers</h1></center>
                </div>
            </div>
        </div>
        <div class="table-responsive">

          <!-- Table with hoverable rows -->
          <table class="table table-hover">
            <thead>
              <tr>
                <th scope="col">#</th>
                <th scope="col">Numèro</th>
                <th scope="col">Fichiers</th>
                <th scope="col">Type Dossier</th>
                <th scope="col">Etat</th>
                <th scope="col">Actions</th>
              </tr>
            </thead>
            <tbody id="myTable">
            @if(auth()->check() && auth()->user()->hasRole('Procureur') || auth()->check() && auth()->user()->hasRole('Secrétaire') || auth()->check() && auth()->user()->hasRole('Président') || auth()->user()->hasRole('Greffier') || auth()->user()->hasRole('Greffier Caissier') || auth()->user()->hasRole('Admin'))
            @foreach($dossiers as $dossier)
            
              <tr>
                <td>{{$dossier->id}}</td>
                <th scope="row">{{$dossier->type}} {{$dossier->numero}}</th>
                <td><i class="bi bi-file-earmark"></i>{{$dossier->count}} fichiers</td>
                <td>{{$dossier->categorie}}</td>
                <td><label class="badge bg-success">{{$dossier->nomEta}}</label></td>
                
                <td>
                  <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i> Options</a>
                  <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                    <li class="dropdown-header text-start">
                      <h6>Options</h6>
                    </li>
                    @can('Update dossier')
                    <li><a class="dropdown-item" href="{{route('dossiers.edit', ['dossier' => $dossier->id])}}"><label class="badge bg-success">Modifier</label></a></li>
                    @endcan
                    @can('Show dossier')
                    <li><a class="dropdown-item" href="{{route('dossiers.show', ['dossier' => $dossier->id])}}"><label class="badge bg-primary">Voir farde</label></a></li>
                    @endcan
                    @can('Create transfert')
                    <li><a class="dropdown-item" href="{{ route('transferts.create', ['dossier_id' => $dossier->id]) }}"><label class="badge bg-warning">Transfert</label></a></li>
                    @endcan
                    @can('Create affecter')
                    <li><a class="dropdown-item" href="{{ route('affecters.create', ['dossier_id' => $dossier->id]) }}"><label class="badge bg-info">Affecter</label></a></li>
                    @endcan
                    @can('Create avis')
                    <li><a class="dropdown-item" href="{{ route('commentaires.create', ['dossier_id' => $dossier->id]) }}"><label class="badge bg-danger">Ajouter Avis</label></a></li>
                    @endcan
                    @can('Create repartir')
                    <li><a class="dropdown-item" href="{{ route('repartirs.create', ['dossier_id' => $dossier->id]) }}"><label class="badge bg-secondary">Répartition</label></a></li>
                    @endcan
                    @can('Valide dossier')
                    @if($dossier->status == 0)
                    <form action="{{ route('dossiers.valide',['dossier' => $dossier->id]) }}" method="POST" id="valider-form">
                        @csrf  
                        @method('POST')
                        <button type="submit" class="dropdown-item" id="valider-btn"><label class="badge bg-primary">Envoyer</label></button>
                    </form>
                    @else
                    <button type="submit" class="dropdown-item" id="valider-btn"><label class="badge bg-secondary">Déjà envoyé</label></button>
                    @endif
                    @endcan

                    @can('Voir dossier')
                    @if($dossier->valide == 0)
                    <form action="{{ route('dossiers.voir',['dossier' => $dossier->id]) }}" method="POST" id="valider-form">
                        @csrf  
                        @method('POST')
                        <button type="submit" class="dropdown-item" id="valider-btn"><label class="badge bg-success">Valider</label></button>
                    </form>
                    @else
                    <button type="submit" class="dropdown-item" id="valider-btn"><label class="badge bg-secondary">Déjà validé</label></button>
                    @endif
                    @endcan
                  </ul>
                </td>
              </tr>
            @endforeach
            @endif

            @if(auth()->check() && auth()->user()->hasRole('Juge'))
            @foreach($dossiersJuge as $dossier)
              <tr>
                <td>{{$dossier->id}}</td>
                <th scope="row">{{$dossier->type}} {{$dossier->numero}}</th>
                <td><i class="bi bi-file-earmark"></i>{{$dossier->count}} fichiers</td>
                <td>{{$dossier->categorie}}</td>
                <td><label class="badge bg-success">{{$dossier->nomEta}}</label></td>

                <td>
                  <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i> Options</a>
                  <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                    <li class="dropdown-header text-start">
                      <h6>Options</h6>
                    </li>

                    <li><a class="dropdown-item" href="{{route('dossiers.show', ['dossier' => $dossier->id])}}"><label class="badge bg-primary">Voir farde</label></a></li>
                  </ul>
                </td>
              </tr>
            @endforeach
            @endif

            @if(auth()->check() && auth()->user()->hasRole('OMP'))
            @foreach($dossiersOMP as $dossier)
              <tr>
                <td>{{$dossier->id}}</td>
                <th scope="row">{{$dossier->type}} {{$dossier->numero}}</th>
                <td><i class="bi bi-file-earmark"></i>{{$dossier->count}} fichiers</td>
                <td>{{$dossier->categorie}}</td>
                <td><label class="badge bg-success">{{$dossier->nomEta}}</label></td>

                <td>
                  <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i> Options</a>
                  <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                    <li class="dropdown-header text-start">
                      <h6>Options</h6>
                    </li>

                    <li><a class="dropdown-item" href="{{route('dossiers.show', ['dossier' => $dossier->id])}}"><label class="badge bg-primary">Voir farde</label></a></li>
                    @can('Create avis')
                    <li><a class="dropdown-item" href="{{ route('commentaires.create', ['dossier_id' => $dossier->id]) }}"><label class="badge bg-warning">Ajouter Avis</label></a></li>
                    @endcan
                  </ul>
                </td>
              </tr>
            @endforeach
            @endif
            
            
            </tbody>
          </table>
          <!-- End Table with hoverable rows -->
          {{$dossiers->links('pagination::bootstrap-4')}}

        </div>
      </div>

      

    </div>
  </div>
  
</section>

</main>



</x-app-layout>