<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Utilisateur extends Model
{
    use HasFactory;
    protected $fillable = [
        'matricule',
        'name',
        'lastname',
        'email',
        'password',
        'contact',
        'role_id',
        'juridiction_id',
    ];

    public function role()
    {
        return $this->belongsTo(Role::class);
    }

    public function juridiction()
    {
        return $this->belongsTo(Juridiction::class);
    }

    public function juge()
    {
        return $this->hasMany(Juge::class);
    }
}
