<?php

namespace App\Http\Controllers;
use App\Models\User;
use App\Models\Role;
use App\Models\JuridictionParque;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\QueryException;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Auth;

use Illuminate\Http\Request;

class UtilisateurController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:View user', ['only' => ['index']]);
        $this->middleware('permission:Create user', ['only' => ['create', 'store']]);
        $this->middleware('permission:Update user', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Delete user', ['only' => ['destroy']]);
    }

    public function index()
    {
        $admin = Auth::user();

        $users = User::where('juridiction_parquet_id', $admin->juridiction_parquet_id)->paginate(10);

        return view('utilisateurs.index', compact('users'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $roles = Role::pluck('name', 'name')->all();
        $juridictionParques = JuridictionParque::All();

        
        return view('utilisateurs.create', compact('roles','juridictionParques'));
    }

    public function store(Request $request)
    {
        $admin = Auth::user();

        $user = new User();
        $user->name = $request->name;
        $user->lastname = $request->lastname;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->juridiction_parquet_id = $admin->juridiction_parquet_id;
        $user->contact = $request->contact;
        $user->matricule = $request->matricule;
        $user->save();

        $user->syncRoles($request->roles);

        return redirect()->route('users.index')->with('success', "Vous avez crée un utilisateur");
    }

    public function edit(User $user)
    {
        $roles = Role::pluck('name', 'name')->all();
        $userRoles = $user->roles->pluck('name', 'name')->all();
        $juridictionParques = juridictionParque::All();

        
        return view('utilisateurs.edit', compact('user', 'roles','juridictionParques','userRoles'));
    }

    public function update(Request $request, User $user)
    {
        $admin = Auth::user();

        $user->name = $request->name;
        $user->lastname = $request->lastname;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->juridiction_parquet_id = $admin->juridiction_parquet_id;
        $user->contact = $request->contact;
        $user->matricule = $request->matricule;
        $user->update();

        $user->syncRoles($request->roles);

        return redirect()->route('users.index')->with('success', "Vous avez modifié un utilisateur");
    }

    public function destroy($userId)
    {
        try {
            $user = User::find($userId);
            $user->delete();

        return redirect('users')->with('success', 'Vous avez supprimé un utilisateur');
        } catch (QueryException $e) {
            $errors = [
                'delete_error' => 'Impossible de supprimer cette Utilisateur!'
            ];
    
            throw ValidationException::withMessages($errors);
        }
        
    }
    
}
