<?php

namespace App\Http\Controllers;
use App\Models\TypeCategorieDossier;

use Illuminate\Http\Request;

class TypeCategorieDossierController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:View categorie dossier', ['only' => ['index']]);
        $this->middleware('permission:Create categorie dossier', ['only' => ['create', 'store']]);
        $this->middleware('permission:Update categorie dossier', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Delete categorie dossier', ['only' => ['destroy']]);
    }

    public function index()
    {
        $typeCategorieDossiers = TypeCategorieDossier::All();

        return view('typeCategorieDossiers.index', compact('typeCategorieDossiers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       

        return view('typeCategorieDossiers.create');
    }

    
    public function store(Request $request)
    {
        $data = $request->validate([
            'nom_categorie' => 'required',
            
        ]);

        TypeCategorieDossier::create($data);


        return redirect()->route('typeCategorieDossiers.index')->with('success', "Vous avez crée un type de categorie du dossier");
    }

    public function edit(TypeCategorieDossier $typeCategorieDossier)
    {
        

        return view('typeCategorieDossiers.edit', compact('typeCategorieDossier'));
    }

    public function update(Request $request,TypeCategorieDossier $typeCategorieDossier)
    {
        $data = $request->validate([
            'nom_categorie' => 'required',
            
        ]);


        $typeCategorieDossier->update([
            'nom_categorie' => $data['nom_categorie'],
            
        ]);

        return redirect()->route('typeCategorieDossiers.index')->with('success', "Vous avez modifié un type de categorie du dossier");
    }

    public function destroy(TypeCategorieDossier $typeCategorieDossier)
    {
        $typeCategorieDossier->delete();

        return redirect()->route('typeCategorieDossiers.index')->with('success', 'Vous avez supprimé un type de categorie du dossier');
    }
}
