<?php

namespace App\Http\Controllers; 
use Illuminate\Http\Request;
use App\Models\Dossier;
use App\Models\TypeCategorieDossier;
use App\Models\Niveau;
use App\Models\Juridiction;
use App\Models\EtatDossier;
use App\Models\TypeDossier;
use App\Models\Juge;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Auth;
use App\Notifications\AffecterNotification;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Notification;
use Illuminate\Database\Eloquent\Builder;

class JugeController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:View affecter', ['only' => ['index']]);
        $this->middleware('permission:Create affecter', ['only' => ['create', 'store']]);
        $this->middleware('permission:Update affecter', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Delete affecter', ['only' => ['destroy']]);
    }
    

public function index(Request $request)

{
    $user = Auth::user();
    $search = $request->input('search');

    $affecters = Juge::query()
    ->join('users', 'juges.user_id', '=', 'users.id')
    ->join('dossiers', 'juges.dossier_id', '=', 'dossiers.id')
    ->join('type_dossiers', 'dossiers.type_dossier_id', '=', 'type_dossiers.id')
    ->select('users.name as name', 'users.lastname as lastname', 'type_dossiers.nom as type', 'dossiers.numero as numero', 'juges.id as id', 'juges.role as role')
    ->whereHas('user', function($query) use ($user){
        $query->where('juridiction_parquet_id', $user->juridiction_parquet_id);
    })
    ->when($search, function (Builder $builder) use ($search) {
            $builder->where('juges.role', 'like', "%{$search}%");
                // ->orWhere('email', 'like', "%{$request->search}%");
        }
    )
    ->paginate(7);

    return view('affecters.index', compact('affecters'));
}

/**
 * Show the form for creating a new resource.
 *
 * @return \Illuminate\Http\Response
 */
public function create($dossier_id)
{

    $dossier = Dossier::find($dossier_id);

    $user = User::find($dossier->user_id);
    
    // dd($user);
    $gref = Auth::user();
    $juridiction = $gref->juridiction_parquet_id;

    $role = Role::where('name', '=', 'Juge')
    ->orWhere('name', '=', 'Président')
     ->first();

     $juges = $role->users()
        ->where('juridiction_parquet_id', $juridiction)
        ->get();
    $dossier = Dossier::findOrFail($dossier_id);

    
    return view('affecters.create', compact('juges','dossier'));
}

public function store(Request $request)
{
    $data = $request->validate([
        'role' => 'required',
        'user_id' => 'required|exists:users,id',
        'dossier_id' => 'required|exists:dossiers,id',
    ]);

    Juge::create($data);

    $role = Role::where('name', 'Juge')->first();

    $users = $role->users()
        ->where('id', $request->user_id)
        ->get();

    
        Notification::send($users, new AffecterNotification($request->dossier_id));
   

    return redirect()->route('affecters.index')->with('success', "Vous avez affecté un dossier");
}

public function edit(Juge $affecter)
{
    $gref = Auth::user();
    $juridiction = $gref->juridiction_parquet_id;

    $role = Role::where('name', 'Président')
    ->orWhere('name', '=', 'Juge')
     ->first();

     $juges = $role->users()
        ->where('juridiction_parquet_id', $juridiction)
        ->get();
    

    
    return view('affecters.edit', compact('juges','affecter'));
}

public function update(Request $request,Juge $affecter)
{
    $data = $request->validate([
        'role' => 'required',
        'user_id' => 'required|exists:users,id',
    ]);


    $affecter->update([
        'role' => $data['role'],
        'user_id' => $data['user_id'],
    ]);

    return redirect()->route('affecters.index')->with('success', "Vous avez modifié l'affectation");
}

public function destroy(Juge $affecter)
{
    $affecter->delete();

    return redirect()->route('affecters.index')->with('success', 'Vous avez supprimé l\'affectation');
}

public function show(Dossier $dossier)
{
    $fichiers = $dossier->fichiers()->get();

    return view('dossiers.show', compact('dossier', 'fichiers'));
}

}
