<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Commune;
use App\Models\Colline;

class CollineController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:Voir colline', ['only' => ['index']]);
        $this->middleware('permission:Créer colline', ['only' => ['create', 'store']]);
        $this->middleware('permission:Modifier colline', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Supprimer colline', ['only' => ['destroy']]);
    }

    public function getCollines(Request $request)
    {
        $collines=Colline::whereCommuneId($request->commune_id)->orderBy('nom')->get();
        return $collines;
    }

    public function index()
    {
        $collines = Colline::all();

        return view('collines.index', compact('collines'));
    }

    
    public function create()
    {
        $communes = Commune::all();
        return view('collines.create', compact('communes'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'nom' => 'required',
            'commune_id' => 'required',
        ]);

        Colline::create($data);


        return redirect()->route('collines.index')->with('success', "Vous avez crée la colline");
    }

    public function edit(Colline $colline)
    {
        $communes = Commune::all();

        return view('collines.edit', compact('colline', 'communes'));
    }

    public function update(Request $request,Colline $colline)
    {
        $data = $request->validate([
            'nom' => 'required',
            'commune_id' => 'required',
        ]);


        $colline->update([
            'nom' => $data['nom'],
            'commune_id' => $data['commune_id'],
        ]);

        return redirect()->route('collines.index')->with('success', "Vous avez modifié la colline");
    }

    public function destroy($collineId)
    {
        $colline = Colline::find($collineId);
        $colline->delete();

        return redirect()->route('collines.index')->with('success', 'Vous avez supprimé la colline');
    }
}
