<?php

namespace App\Http\Controllers;
use App\Models\Categorie_professionnelle;

use Illuminate\Http\Request;

class CategorieController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:Voir categorie', ['only' => ['index']]);
        $this->middleware('permission:Créer categorie', ['only' => ['create', 'store']]);
        $this->middleware('permission:Modifier categorie', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Supprimer categorie', ['only' => ['destroy']]);
    }
    
    public function index()
    {
        $categories = Categorie_professionnelle::all();

        return view('categories.index', compact('categories'));
    }

    
    public function create()
    {
        return view('categories.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'nom' => 'required',
            
        ]);

        Categorie_professionnelle::create($data);


        return redirect()->route('categories.index')->with('success', "Vous avez crée la categorie");
    }

    public function edit(Categorie_professionnelle $category)
    {
       

        return view('categories.edit', compact('category'));
    }

    public function update(Request $request,Categorie_professionnelle $category)
    {
        $data = $request->validate([
            'nom' => 'required',
            
        ]);


        $category->update([
            'nom' => $data['nom'],
            
        ]);

        return redirect()->route('categories.index')->with('success', "Vous avez modifié la categorie");
    }

    public function destroy($categorieId)
    {
        $category = Categorie_professionnelle::find($categorieId);
        $category->delete();

        return redirect()->route('categories.index')->with('success', 'Vous avez supprimé la categorie');
    }
}
