<x-app-layout>



<main id="main" class="main">

    <div class="pagetitle">
      <h1>Profile</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="{{route('users.index')}}">Accueil</a></li>
          <li class="breadcrumb-item">Forms</li>
          <li class="breadcrumb-item active">Mise en page</li>
        </ol>
      </nav>
    </div>

    <section class="section profile">
    @if ($errors->has('update_error'))
        <div class="alert alert-danger">
          <i class="ri-alert-fill"></i> {{ $errors->first('delete_error') }}
        </div>
    @endif
    @if(session('success'))
        <div class="alert alert-success">
          <i class="ri-alert-fill"></i> {{ session('success') }}
        </div>
    @endif
      <div class="row">
        <div class="col-xl-4">

          <div class="card">
            <div class="card-body profile-card pt-4 d-flex flex-column align-items-center">
           
              <img src="/assets/img/NO-IMAGE-AVAILABLE.jpg" alt="Profile" class="rounded-circle">
              
              <h2>{{ $user->name }} {{ $user->lastname }}</h2>
              <h3>
                      @if (!empty($user->getRoleNames()))
                      @foreach($user->getRoleNames() as $rolename)
                      <label class="badge bg-primary mx-1">{{ $rolename }}</label>
                      @endforeach
                      @endif
              </h3>
              <h3>{{ $user->email }}</h3>
              <div class="social-links mt-2">
                <a href="#" class="twitter"><i class="bi bi-twitter"></i></a>
                <a href="#" class="facebook"><i class="bi bi-facebook"></i></a>
                <a href="#" class="instagram"><i class="bi bi-instagram"></i></a>
                <a href="#" class="linkedin"><i class="bi bi-linkedin"></i></a>
              </div>
            </div>
          </div>

        </div>

        <div class="col-xl-8">

          <div class="card">
            <div class="card-body pt-3">
              
              <ul class="nav nav-tabs nav-tabs-bordered">

                <li class="nav-item">
                  <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#profile-overview">Overview</button>
                </li>

                <li class="nav-item">
                  <button class="nav-link" data-bs-toggle="tab" data-bs-target="#profile-edit">Edit Profile</button>
                </li>

                

              </ul>
              <div class="tab-content pt-2">

                <div class="tab-pane fade show active profile-overview" id="profile-overview">
                  <h5 class="card-title">Détailles du Profile</h5>

                  <div class="row">
                    <div class="col-lg-3 col-md-4 label ">Nom</div>
                    <div class="col-lg-9 col-md-8">{{ $user->name }} {{ $user->lastname }}</div>
                  </div>

                  <div class="row">
                    <div class="col-lg-3 col-md-4 label">Rôle</div>
                    <div class="col-lg-9 col-md-8">
                      @if (!empty($user->getRoleNames()))
                      @foreach($user->getRoleNames() as $rolename)
                      <label class="badge bg-primary mx-1">{{ $rolename }}</label>
                      @endforeach
                      @endif
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-lg-3 col-md-4 label">Juridiction</div>
                    <div class="col-lg-9 col-md-8">{{ $user->juridiction_parquet_id }}</div>
                  </div>

                  <div class="row">
                    <div class="col-lg-3 col-md-4 label">Email</div>
                    <div class="col-lg-9 col-md-8">{{ $user->email }}</div>
                  </div>

                </div>

                <div class="tab-pane fade profile-edit pt-3" id="profile-edit">

                  
                <form method="POST" action="{{ route('users.update', $user->id) }}">
                  @csrf
                  @method('PATCH')
                    <div class="row mb-3">
                      <label for="profileImage" class="col-md-4 col-lg-3 col-form-label">Profile Image</label>
                      <div class="col-md-8 col-lg-9">
                        <img src="/assets/img/NO-IMAGE-AVAILABLE.jpg" alt="Profile">
                        <div class="pt-2">
                          <a href="#" class="btn btn-primary btn-sm" title="Upload new profile image"><i class="bi bi-upload"></i></a>
                          <a href="#" class="btn btn-danger btn-sm" title="Remove my profile image"><i class="bi bi-trash"></i></a>
                        </div>
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="fullName" class="col-md-4 col-lg-3 col-form-label">Nom</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="matricule" type="text" class="form-control" id="fullName" value="{{ $user->matricule }}">
                      </div>
                    </div>
                    <div class="row mb-3">
                      <label for="fullName" class="col-md-4 col-lg-3 col-form-label">Nom</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="name" type="text" class="form-control" id="fullName" value="{{ $user->name }}">
                      </div>
                    </div>
                    <div class="row mb-3">
                      <label for="fullName" class="col-md-4 col-lg-3 col-form-label">Prénom</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="lastname" type="text" class="form-control" id="fullName" value="{{ $user->lastname }}">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="Job" class="col-md-4 col-lg-3 col-form-label">Rôle</label>
                      <div class="col-md-8 col-lg-9">
                      <select name ="roles[]" class="form-control" multiple>
                        <option selected disabled>Choisisser le rôle</option>
                      @foreach($roles as $role)
                        <option value="{{$role}}" {{ in_array($role, $userRoles) ? 'selected':'' }}>{{$role}}</option>
                      @endforeach
                        
                      </select>
                      </div>
                    </div>

                <div class="row mb-3">
                  <label for="cours" class="col-md-4 col-lg-3 col-form-label">Juridiction</label>
                  <div class="col-md-8 col-lg-9">
                    <select name ="juridiction_id" class="form-control">
                      <option selected disabled>Choisisser la juridiction</option>
                      @foreach($juridictionParques as $juridiction)
                        <option value="{{$juridiction->id}}" @if($juridiction->id === $user->juridiction_id) selected @endif>{{$juridiction->nom}}</option>
                      @endforeach  
                    </select>
                    </div>
                </div>

                    <div class="row mb-3">
                      <label for="Email" class="col-md-4 col-lg-3 col-form-label">Email</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="email" type="email" class="form-control" id="Email" value="{{ $user->email }}">
                      </div>
                    </div>

                    <div class="row mb-3">
                      <label for="fullName" class="col-md-4 col-lg-3 col-form-label">Nom</label>
                      <div class="col-md-8 col-lg-9">
                        <input name="contact" type="text" class="form-control" id="fullName" value="{{ $user->contact }}">
                      </div>
                    </div>

                    <div class="text-center">
                      <button type="submit" class="badge bg-primary p-2 ms-6">Soumettre</button>
                    </div>
                  </form>

                </div>

                

              </div>

            </div>
          </div>

        </div>
      </div>
    </section>

  </main>

       
</x-app-layout>
