<x-app-layout>


<main id="main" class="main">

<div class="pagetitle">
  <h1>General Tables</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="">Table de bord</a></li>
      <li class="breadcrumb-item">Tables</li>
      <li class="breadcrumb-item active">General</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section">
@if ($errors->has('delete_error'))
    <div class="alert alert-danger">
    <i class="ri-alert-fill"></i> {{ $errors->first('delete_error') }}
    </div>
@endif
@if(session('success'))
    <div class="alert alert-success">
      <i class="ri-alert-fill"></i> {{ session('success') }}
    </div>
@endif
  
  <div class="row">
    <div class="col-lg-4">
        <div class="form-group">
            <input type="search" id="myInput" class="form-control" placeholder="Search ..." onkeyup="myFunction()">
        </div>
    </div>


    <div class="col-auto text-end float-end ms-auto download-grp">
    
    

    
    <a href="{{route('validers.index')}}" class="btn btn-primary"><i class="bi bi-plus"></i> Voir validations</a>
    

</div>

               

</div><br>
  
  <div class="row">
    <div class="col-lg-12">

      

      <div class="card">
        <div class="page-header">
            <div class="row align-items-center">
                <div class="col">
                    <center><h1 class="card-title">Les avis</h1></center>
                </div>
            </div>
        </div>

          <!-- Table with hoverable rows -->
          <table class="table table-hover">
            <thead>
              <tr>
                <th scope="col">#</th>
                <th scope="col">Numèro du dossier</th>
                <th scope="col">Avis</th>
                <th colspan="2">Actions</th>
              </tr>
            </thead>
            <tbody id="myTable">
            
            @foreach($commentaires as $commentaire)
            
              <tr>
                <td>{{$commentaire->id}}</td>
                <td>{{$commentaire->nom}} {{$commentaire->numero}}</td>
                <td>
                    <a href="{{ asset('assets/tousfichiers/' . $commentaire->avis) }}" target="_blank">
                        {{ $commentaire->avis }}
                    </a>
                </td>
                
                <td>
                  <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i> Options</a>
                  <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                    <li class="dropdown-header text-start">
                      <h6>Options</h6>
                    </li>
                    @can('Update avis')
                    <li><a class="dropdown-item" href="{{ route('commentaires.edit', $commentaire->id) }}"><label class="badge bg-primary">Modifier avis</label></a></li>
                    @endcan
                    @can('Valide avis')
                    <li><a class="dropdown-item" href="{{ route('validers.create', ['commentaire_id' => $commentaire->id]) }}"><label class="badge bg-primary">Valide Avis</label></a></li>
                    @endcan
                  </ul>
                </td>
                
              </tr>
            @endforeach
           
            </tbody>
          </table>
          <!-- End Table with hoverable rows -->

        </div>
      </div>

      

    </div>
  </div>
 
</section>

</main>
</x-app-layout>