<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transfert_dossiers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('dossier_id');
            $table->foreign('dossier_id')->references('id')->on('dossiers')->onUpdate('cascade')->onDelete('cascade');
            $table->unsignedBigInteger('juridiction_id');
            $table->foreign('juridiction_id')->references('id')->on('juridictions')->onUpdate('cascade')->onDelete('cascade');
            $table->date('dateT');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transfert_dossiers');
    }
};
