<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\TypeFichier;
use Illuminate\Database\Eloquent\Builder;

class TypeFichierController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:View type fichier', ['only' => ['index']]);
        $this->middleware('permission:Create type fichier', ['only' => ['create', 'store']]);
        $this->middleware('permission:Update type fichier', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Delete type fichier', ['only' => ['destroy']]);
    }

  public function index(Request $request)
    {
        $typefichiers = TypeFichier::query()
        ->when(
            $request->search,
            function (Builder $builder) use ($request) {
                $builder->where('type', 'like', "%{$request->search}%");
                    // ->orWhere('type_categorie_dossiers.nom_categorie', 'like', "%{$request->search}%");
            }
        )
        ->paginate(10);
    
        return view('typefichiers.index', compact('typefichiers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        

        return view('typefichiers.create');
    }

    
    public function store(Request $request)
    {
        $data = $request->validate([
            'type' => 'required',
            
        ]);

        TypeFichier::create($data);


        return redirect()->route('typefichiers.index')->with('success', "Vous avez crée un type du fichier");
    }

    public function edit(TypeFichier $typefichier)
    {

        return view('typefichiers.edit', compact('typefichier'));
    }

    public function update(Request $request,TypeFichier $typefichier)
    {
        $data = $request->validate([
            'type' => 'required',
            
        ]);


        $typefichier->update([
            'type' => $data['type'],
            
        ]);

        return redirect()->route('typefichiers.index')->with('success', "Vous avez modifié un type du fichier");
    }

    public function destroy(TypeFichier $typefichier)
    {
        $typefichier->delete();

        return redirect()->route('typefichiers.index')->with('success', 'Vous avez supprimé un type du fichier');
    }
}
