<?php

namespace App\Http\Controllers;
use Illuminate\Database\Eloquent\Builder;

use Illuminate\Http\Request;
use App\Models\EtatDossier;

class EtatDossierController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:View etat dossier', ['only' => ['index']]);
        $this->middleware('permission:Create etat dossier', ['only' => ['create', 'store']]);
        $this->middleware('permission:Update etat dossier', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Delete etat dossier', ['only' => ['destroy']]);
    }
   
    public function index(Request $request)
    {
        $search = $request->input('search');

        $etats = EtatDossier::query()
            ->when($search, function (Builder $builder) use ($search) {
                $builder->where('nom', 'like', "%{$search}%");
            })
            ->paginate(10);

        return view('etatdossiers.index', compact('etats'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        

        return view('etatdossiers.create');
    }

    
    public function store(Request $request)
    {
        $data = $request->validate([
            'nom' => 'required',
            
        ]);

        EtatDossier::create($data);


        return redirect()->route('etatdossiers.index')->with('success', "Vous avez crée un etat du dossier");
    }

    public function edit(EtatDossier $etatdossier)
    {
        

        return view('etatdossiers.edit', compact('etatdossier'));
    }

    public function update(Request $request,EtatDossier $etatdossier)
    {
        $data = $request->validate([
            'nom' => 'required',
           
        ]);


        $etatdossier->update([
            'nom' => $data['nom'],
            
        ]);

        return redirect()->route('etatdossiers.index')->with('success', "Vous avez modifié un etat du dossier");
    }

    public function destroy(EtatDossier $etatdossier)
    {
        $etatdossier->delete();

        return redirect()->route('etatdossiers.index')->with('success', 'Vous avez supprimé un etat du dossier');
    }

}
