<x-app-layout>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Les utilisateurs</h1>
          </div>
          <div class="col-sm-6">
            <div class="breadcrumb float-sm-right">
              @include('role-permission.nav-links')
            </div>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->

    @if ($errors->has('delete_error'))
    <div class="alert alert-danger">
    <i class="ri-alert-fill"></i> {{ $errors->first('delete_error') }}
    </div>
    @endif
    @if(session('success'))
        <div class="alert alert-success">
          <i class="ri-alert-fill"></i> {{ session('success') }}
        </div>
    @endif

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card">
            <div class="card-header">
                <h3 class="card-title">Les utilisateurs</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>ID</th>
                    <th>Nom</th>
                    <th>Prénom</th>
                    <th>Email</th>
                    <th>Rôle</th>
                    <th>Actions</th>
                  </tr>
                  </thead>
                  <tbody>
                  @foreach($users as $user)
                  <tr>
                    <td>{{$user->id}}</td>
                    <td>{{$user->name}}</td>
                    <td>{{$user->lastname}}</td>
                    <td>{{$user->email}}</td>
                    <td>
                      @if (!empty($user->getRoleNames()))
                      @foreach($user->getRoleNames() as $rolename)
                      <label class="badge bg-primary mx-1">{{ $rolename }}</label>
                      @endforeach
                      @endif
                    </td>
                    <td>
                      <a href="{{ route('utilisateurs.edit', $user->id) }}" class="btn btn-success"><i class="nav-icon far fa-edit" title="Modifier"></i>Activer</a>
                      
                    </td>
                    
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>ID</th>
                    <th>Nom</th>
                    <th>Prénom</th>
                    <th>Email</th>
                    <th>Rôle</th>
                    <th>Actions</th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
</x-app-layout>