<x-app-layout>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Les communes</h1>
          </div>
          <div class="col-sm-6">
            <div class="breadcrumb float-sm-right">
            @can('Créer commune')
              <a href="{{route('communes.create')}}" class="btn btn-warning">Ajouter commune</a>
            @endcan
            </div>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->

    @if ($errors->has('delete_error'))
    <div class="alert alert-danger">
    <i class="ri-alert-fill"></i> {{ $errors->first('delete_error') }}
    </div>
    @endif
    @if(session('success'))
        <div class="alert alert-success">
          <i class="ri-alert-fill"></i> {{ session('success') }}
        </div>
    @endif

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card">
            <div class="card-header">
                <h3 class="card-title">Les communes</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>ID</th>
                    <th>Nom</th>
                    <th>Région</th>
                    <th>Actions</th>
                  </tr>
                  </thead>
                  <tbody>
                  @foreach($communes as $commune)
                  <tr>
                    <td>{{$commune->id}}</td>
                    <td>{{$commune->nom}}</td>
                    <td>{{$commune->region->nom}}</td>
                    <td>
                    @can('Modifier commune')
                      <a href="{{ route('communes.edit', $commune->id) }}" class="btn btn-success"><i class="nav-icon far fa-edit" title="Modifier"></i></a>
                    @endcan
                    @can('Supprimer commune')
                      <a href="{{url('communes/'.$commune->id.'/delete')}}" onclick="return confirm('Vous voulez supprimer ça?')" class="btn btn-danger"><i class="nav-icon fa fa-trash" title="Supprimer"></i></a>
                    @endcan
                    </td>
                    
                  </tr>
                  @endforeach
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>ID</th>
                    <th>Nom</th>
                    <th>Région</th>
                    <th>Actions</th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
</x-app-layout>