<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Beneficiaire extends Model
{
    use HasFactory;

    protected $fillable = [
        'nom',
        'prenom',
        'email',
        'telephone',
        'age',
        'sexe',
        'projet',
        'montant',
        'password',
        'categorie_id',
        'secteur_id',
        'colline_id',
        'user_id',
        ];
    
      
    public function categorie()
    {
        return $this->belongsTo(Categorie_professionnelle::class);
    }

    public function secteur()
    {
        return $this->belongsTo(Secteur_activity::class);
    }

    public function colline()
    {
        return $this->belongsTo(Colline::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
