<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Spatie\Permission\Models\Role;
use App\Models\Institution;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\QueryException;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:Voir utilisateur', ['only' => ['index']]);
        $this->middleware('permission:Créer utilisateur', ['only' => ['create', 'store']]);
        $this->middleware('permission:Modifier utilisateur', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Supprimer utilisateur', ['only' => ['destroy']]);
    }

    public function index()
    {
        $admin = Auth::user();

        $users = User::all();

        return view('utilisateurs.index', compact('users'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $roles = Role::pluck('name', 'name')->all();
        $institution = Institution::All();

        
        return view('utilisateurs.create', compact('institution'));
    }

    public function store(Request $request)
    {
        $admin = Auth::user();

        $user = new User();
        $user->name = $request->name;
        $user->lastname = $request->lastname;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->status = $request->status;
        $user->save();

        // $user->syncRoles($request->roles);

        return redirect()->route('users.index')->with('success', "Vous avez crée un utilisateur");
    }

    public function edit(User $user)
    {
        $roles = Role::pluck('name', 'name')->all();
        $userRoles = $user->roles->pluck('name', 'name')->all();
        $institution = Institution::All();

        
        return view('utilisateurs.edit', compact('user', 'institution'));
    }

    public function update(Request $request, User $user)
    {
        $admin = Auth::user();

        $user->name = $request->name;
        $user->lastname = $request->lastname;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->status = $request->status;
        $user->update();

        // $user->syncRoles($request->roles);

        return redirect()->route('users.index')->with('success', "Vous avez modifié un utilisateur");
    }

    public function destroy($userId)
    {
        try {
            $user = User::find($userId);
            $user->delete();

        return redirect('users')->with('success', 'Vous avez supprimé un utilisateur');
        } catch (QueryException $e) {
            $errors = [
                'delete_error' => 'Impossible de supprimer cette Utilisateur!'
            ];
    
            throw ValidationException::withMessages($errors);
        }
        
    }
}
