<?php

namespace App\Http\Controllers;
use App\Models\Commune;
use App\Models\Region;

use Illuminate\Http\Request;

class CommuneController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:Voir commune', ['only' => ['index']]);
        $this->middleware('permission:Créer commune', ['only' => ['create', 'store']]);
        $this->middleware('permission:Modifier commune', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Supprimer commune', ['only' => ['destroy']]);
    }

    public function getCommunes(Request $request)
    {
        $communes=Commune::whereRegionId($request->region_id)->orderBy('nom')->get();
        return $communes;
    }

    public function index()
    {
        $communes = Commune::all();

        return view('communes.index', compact('communes'));
    }

    
    public function create()
    {
        $regions = Region::all();
        return view('communes.create', compact('regions'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'nom' => 'required',
            'region_id' => 'required',
        ]);

        Commune::create($data);


        return redirect()->route('communes.index')->with('success', "Vous avez crée la commune");
    }

    public function edit(Commune $commune)
    {
        $regions = Region::all();

        return view('communes.edit', compact('commune', 'regions'));
    }

    public function update(Request $request,Commune $commune)
    {
        $data = $request->validate([
            'nom' => 'required',
            'region_id' => 'required',
        ]);


        $commune->update([
            'nom' => $data['nom'],
            'region_id' => $data['region_id'],
        ]);

        return redirect()->route('communes.index')->with('success', "Vous avez modifié la commune");
    }

    public function destroy($communeId)
    {
        $commune = Commune::find($communeId);
        $commune->delete();

        return redirect()->route('communes.index')->with('success', 'Vous avez supprimé la commune');
    }
}
