<?php

namespace App\Http\Controllers; 
use Illuminate\Http\Request;
use App\Models\Commentaire;
use App\Models\TypeCategorieDossier;
use App\Models\Niveau;
use App\Models\Juridiction;
use App\Models\EtatDossier;
use App\Models\TypeDossier;
use App\Models\Valider;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Auth;
use App\Notifications\ValideAvisNotification;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Notification;
use Illuminate\Database\Eloquent\Builder;

class ValiderController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:View avis', ['only' => ['index']]);
        $this->middleware('permission:Create avis', ['only' => ['create', 'store']]);
        $this->middleware('permission:Update avis', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Delete avis', ['only' => ['destroy']]);
    }
    

public function index(Request $request)

{

    $user = Auth::user();

    $validers = Valider::join('commentaires', 'validers.commentaire_id', '=', 'commentaires.id')
    ->join('dossiers', 'commentaires.dossier_id', 'dossiers.id')
    ->select('validers.id', 'commentaires.avis as comment', 'validers.avis')
    ->whereHas('user', function($query) use ($user){
        $query->where('juridiction_parquet_id', $user->juridiction_parquet_id);
    })
    ->get();

    return view('valide.index', compact('validers'));
}


public function create($commentaire_id)
{

    $commentaire = Commentaire::findOrFail($commentaire_id);

   
    return view('valide.create', compact('commentaire'));
}

public function store(Request $request)
{
   
    $user = Auth::user();

    $valider = new Valider();
    $valider->avis = $request->avis;
    $valider->commentaire_id = $request->commentaire_id;
    $valider->user_id = $user->id;
    $valider->save();

    $gref = Auth::user();
    $juridiction = $gref->juridiction_parquet_id;

    $role = Role::where('name', 'OMP')
    ->orWhere('name', 'Secrétaire')
    ->first();

    $users = $role->users()
        ->where('juridiction_parquet_id', $juridiction)
        ->get();

    
        Notification::send($users, new ValideAvisNotification($request->avis));
   

    return redirect()->back()->with('success', "Vous avez validé avis de l'OMP");
}

public function edit(Repartir $repartir)
{
    
}

public function update(Request $request,Repartir $repartir)
{
    
}

public function destroy(Repartir $repartir)
{
    
}

public function show(Dossier $dossier)
{
    
}

}
