<?php

namespace App\Http\Controllers;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use App\Models\Juridiction;
use App\Models\Dossier;
use App\Models\Jugement;

class JugementsController extends Controller
{
    public function index(Request $request)
    {
        $search = $request->input('search');

        $jugements = Jugement::query()
        ->when($search, function (Builder $builder) use ($search) {
                $builder->where('date', 'like', "%{$search}%")
                    ->orWhere('description', 'like', "%{$search}%");
            }
        )
        ->paginate(7);
        

        return view('jugements.index', compact('jugements'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $dossiers = Dossier::All();
        $juridictions = Juridiction::All();

        
        return view('jugements.create', compact('dossiers','juridictions'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'date' => 'required',
            'description' => 'required',
            'dossier_id' => 'required|exists:dossiers,id',
            'juridiction_id' => 'required|exists:juridictions,id',
        ]);

        Jugement::create($data);

        return redirect()->route('jugements.index')->with('success', "jugement Successfully Created");
    }

    public function edit(Jugement $jugement)
    {
        $dossiers = Dossiers::All();
        $juridictions = Juridictions::All();

        
        return view('jugements.edit', compact('dossiers','juridictions'));
    }

    public function update(Request $request,Jugement $jugement)
    {
        $data = $request->validate([
            
            'description' => 'required',
            'dossiers_id' => 'required|exists:dossiers,id',
            'juridictions_id' => 'required|exists:juridictions,id',
        ]);


        $jugement->update([
            'description' => $data['description'],
            'dossiers_id' => $data['dossiers_id'],
            'juridictions_id' => $data['juridictions_id'],
        ]);

        return redirect()->route('jugements.index')->with('success', "jugement updated successfully");
    }

    public function destroy(Jugement $jugement)
    {
        $jugement->delete();

        return redirect()->route('jugements.index')->with('success', 'jugements deleted successful');
    }
}
