<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Commentaire;
use App\Models\Dossier;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Auth;
use App\Notifications\DossierAjouterNotification;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Notification;

class CommentaireController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:View avis', ['only' => ['index']]);
        $this->middleware('permission:Create avis', ['only' => ['create', 'store']]);
        $this->middleware('permission:Update avis', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Delete avis', ['only' => ['destroy']]);
    }

    public function index()

{
    $commentaires = Commentaire::join('dossiers', 'commentaires.dossier_id', '=', 'dossiers.id')
    ->join('type_dossiers', 'dossiers.type_dossier_id', '=', 'type_dossiers.id')
    ->select('commentaires.id', 'dossiers.numero', 'type_dossiers.nom', 'commentaires.avis')
    ->orderBy('commentaires.id', 'desc')
    ->get();

    $commentaireDo = Commentaire::join('dossiers', 'commentaires.dossier_id', '=', 'dossiers.id')
    ->select('commentaires.id', 'dossiers.numero', 'commentaires.avis')
    ->orderBy('commentaires.id', 'desc')
    ->get();

    return view('commentaires.index', compact('commentaires', 'commentaireDo'));
}

/**
 * Show the form for creating a new resource.
 *
 * @return \Illuminate\Http\Response
 */
public function create($dossier_id)
{
    
    $dossier = Dossier::findOrFail($dossier_id);
    
    return view('commentaires.create', compact('dossier'));
}

public function store(Request $request)
{
    $gref = Auth::user();
    $juridiction = $gref->juridiction_parquet_id;
    
        $commentaire = new Commentaire();
        $commentaire->avis = $request->avis;
        $commentaire->dossier_id = $request->dossier_id;
        $commentaire->save();

        $role = Role::where('name', 'Procureur')->first();

        $users = $role->users()
            ->where('juridiction_parquet_id', $juridiction)
            ->get();

    
        Notification::send($users, new DossierAjouterNotification($request->dossier_id));

    return redirect()->route('commentaires.index')->with('success', "Vous avez ajouté un avis");
}

public function edit(Commentaire $commentaire)
{
    

    
    return view('commentaires.edit', compact('commentaire'));
}

public function update(Request $request,Commentaire $commentaire)
{
    $data = $request->validate([
        'avis' => 'required',
    ]);


    $commentaire->update([
        'avis' => $data['avis'],
    ]);

    return redirect()->route('commentaires.index')->with('success', "Vous avez modifié un avis");
}

public function destroy(Commentaire $commentaire)
{
    $commentaire->delete();

    return redirect()->route('commentaires.index')->with('success', 'Vous avez supprimé un avis');
}


}
