<?php

namespace App\Http\Controllers;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use App\Models\Juridiction;
use App\Models\Dossier;
use App\Models\Audience;
use App\Models\Juge;
use Illuminate\Support\Facades\Auth;

class AudiencesController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:View audience', ['only' => ['index']]);
        $this->middleware('permission:Create audience', ['only' => ['create', 'store']]);
        $this->middleware('permission:Update audience', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Delete audience', ['only' => ['destroy']]);
    }
    
        public function index(Request $request)
    {

        $user = Auth::user();

        $search = $request->input('search');

        $audiences = Audience::join('dossiers', 'audiences.dossier_id', '=', 'dossiers.id')
        ->join('type_dossiers', 'dossiers.type_dossier_id', '=', 'type_dossiers.id')
        ->select('audiences.id', 'audiences.description', 'type_dossiers.nom as type', 'dossiers.numero', 'audiences.date')
        ->whereHas('dossier.user', function($query) use ($user){
            $query->where('juridiction_parquet_id', $user->juridiction_parquet_id);
        })
        ->when($search, function (Builder $builder) use ($search) {
                $builder->where('date', 'like', "%{$search}%")
                    ->orWhere('description', 'like', "%{$search}%");
            }
        )
        ->orderBy('audiences.id', 'desc')
        ->paginate(7);

        $audiencesParquet = Audience::join('dossiers', 'audiences.dossier_id', '=', 'dossiers.id')
        ->join('type_dossiers', 'dossiers.type_dossier_id', '=', 'type_dossiers.id')
        ->join('juridiction_parques', 'audiences.juridiction_parquet_id', '=', 'juridiction_parques.id')
        ->select('audiences.id', 'audiences.description', 'type_dossiers.nom as type', 'dossiers.numero', 'audiences.date', 'juridiction_parques.nom', 'juridiction_parques.commune')
        ->when($search, function (Builder $builder) use ($search) {
            $builder->where('date', 'like', "%{$search}%")
                ->orWhere('description', 'like', "%{$search}%");
        }
        )
        ->orderBy('audiences.id', 'desc')
        ->paginate(7);

        return view('audiences.index', compact('audiences','audiencesParquet'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        $user = Auth::user();

        $dossiers = Dossier::join('type_dossiers', 'dossiers.type_dossier_id', '=', 'type_dossiers.id')
        ->select('dossiers.id', 'type_dossiers.nom', 'dossiers.numero')
        ->whereHas('user', function($query) use ($user){
            $query->where('juridiction_parquet_id', $user->juridiction_parquet_id);
        })
        ->get();

        $dossiersJuge = Juge::join('dossiers', 'juges.dossier_id', '=', 'dossiers.id')
        ->join('type_dossiers', 'dossiers.type_dossier_id', '=', 'type_dossiers.id')
        ->select('dossiers.id', 'type_dossiers.nom', 'dossiers.numero')
        ->where('juges.user_id', auth()->id())
        ->get();
        $juridictions = Juridiction::All();

        
        return view('audiences.create', compact('dossiers','juridictions', 'dossiersJuge'));
    }

    public function store(Request $request)
    {
        $admin = Auth::user();

        $audience = new Audience();
        $audience->date = $request->date;
        $audience->description = $request->description;
        $audience->dossier_id = $request->dossier_id;
        $audience->juridiction_parquet_id = $admin->juridiction_parquet_id;
        $audience->save();

        return redirect()->route('audiences.index')->with('success', "Vous avez crée une audience");
    }

    public function edit(Audience $audience)
    {
        $dossiers = Dossier::All();
        $juridictions = Juridiction::All();

        
        return view('audiences.edit', compact('audience','dossiers','juridictions'));
    }

    public function update(Request $request,Audience $audience)
    {
        $data = $request->validate([
            'date' => 'required',
            'description' => 'required',
            'dossier_id' => 'required|exists:dossiers,id',
        ]);


        $audience->update([
            'date' => $data['date'],
            'description' => $data['description'],
            'dossier_id' => $data['dossier_id'],
        ]);

        return redirect()->route('audiences.index')->with('success', "Vous avez modifié une audience");
    }

    public function destroy(Audience $audience)
    {
        $audience->delete();

        return redirect()->route('audiences.index')->with('success', 'Vous avez supprimé une audience');
    }
}
