<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Niveau;

class NiveauController extends Controller
{
   
    public function index()
    {
        $niveaux = Niveau::all();

        return view('niveau.index', compact('niveaux'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        

        return view('niveau.create');
    }

    
    public function store(Request $request)
    {
        $data = $request->validate([
            'nom' => 'required',
            
        ]);

        Niveau::create($data);


        return redirect()->route('niveau.index')->with('success', "niveau Successfully Created");
    }

    public function edit(Niveau $niveau)
    {
       

        return view('niveau.edit', compact('niveau'));
    }

    public function update(Request $request,Niveau $niveau)
    {
        $data = $request->validate([
            'nom' => 'required',
            
        ]);


        $niveau->update([
            'nom' => $data['nom'],
            
        ]);

        return redirect()->route('niveau.index')->with('success', "Niveau updated successfully");
    }

    public function destroy(Niveau $niveau)
    {
        $niveau->delete();

        return redirect()->route('niveau.index')->with('success', 'niveau deleted successful');
    }
 
}
