<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Juridiction;
use App\Models\JuridictionParque;
use App\Models\User;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\QueryException;
use Illuminate\Validation\ValidationException;

class JuridictionsController extends Controller
{


    public function __construct()
    {
        $this->middleware('permission:View juridiction', ['only' => ['index']]);
        $this->middleware('permission:Create juridiction', ['only' => ['create', 'store']]);
        $this->middleware('permission:Update juridiction', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Delete juridiction', ['only' => ['destroy']]);
    }

    public function index(Request $request)
    {
        $juridictions = JuridictionParque::where('nom', '!=', 'parquet')
        ->when(
            $request->search,
            function (Builder $builder) use ($request) {
                $builder->where('nom', 'like', "%{$request->search}%");
            }
        )
        ->paginate(10);

        


        return view('juridictions.index', compact('juridictions'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
        $provinces = JuridictionParque::$provinces;
        return view('juridictions.create', compact('provinces'));
    }

    
    public function store(Request $request)
    {
        $data = $request->validate([
            'nom' => 'required',
            'province' => 'required',
            'commune' => 'required',
        ]);

        JuridictionParque::create($data);


        return redirect()->route('juridictions.index')->with('success', "Juridictions Successfully Created");
    }

    public function edit(JuridictionParque $juridiction)
    {
        $provinces = JuridictionParque::$provinces;

        return view('juridictions.edit', compact('juridiction','provinces'));
    }

    public function update(Request $request,JuridictionParque $juridiction)
    {
        $data = $request->validate([
            'nom' => 'required',
            'province' => 'required',
            'commune' => 'required',
        ]);


        $juridiction->update([
            'nom' => $data['nom'],
            'province' => $data['province'],
            'commune' => $data['commune'],
            
        ]);

        return redirect()->route('juridictions.index')->with('success', "Juridiction updated successfully");
    }

    public function destroy(JuridictionParque $juridiction)
    {
        try {
            $juridiction->delete();
    
            return redirect()->route('juridictions.index')->with('success', 'juridiction deleted successful');
        } catch (QueryException $e) {
            $errors = [
                'delete_error' => 'Impossible de supprimer cette Juridiction'
            ];
    
            throw ValidationException::withMessages($errors);
        }

        
    }
}
