@php
  $unreadNotificationsCount = auth()->user()->unreadNotifications->count();
@endphp
<header id="header" class="header fixed-top d-flex align-items-center">

    <div class="d-flex align-items-center justify-content-between">
      <a href="#" class="logo d-flex align-items-center">
        <img src="{{ URL::to('assets/img/logojust.png') }}" alt="">
        <span class="d-none d-lg-block">Justice</span>
      </a>
      <i class="bi bi-list toggle-sidebar-btn"></i>
    </div><!-- End Logo -->

    

    <nav class="header-nav ms-auto">
      <ul class="d-flex align-items-center">

      <li class="nav-item dropdown">

        <a class="nav-link nav-icon" href="#" data-bs-toggle="dropdown">
          <i class="bi bi-bell"></i>
          <span class="badge bg-primary badge-number">{{ $unreadNotificationsCount }}</span>
        </a><!-- End Notification Icon -->

        <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow notifications">
          
          <li class="dropdown-header">
            
            <span class="badge rounded-pill bg-primary p-2 ms-2">Vous avez {{ $unreadNotificationsCount }} nouvelles notifications</span>
          </li>
          <li>
            <hr class="dropdown-divider">
          </li>
          @if(auth()->check() && auth()->user()->hasRole('Greffier'))
            @foreach(auth()->user()->unreadNotifications as $notification)
                <li class="notification-item">
                    <i class="bi bi-exclamation-circle text-warning"></i>
                    <div>
                        <h4>Nouveau Dossier</h4>
                        <p>{{ $notification->data['message'] }}</p>
                        <p>{{ $notification->created_at }}</p>
                        <form action="{{ route('markAsRead', ['notification' => $notification->id]) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('POST')
                            <label class="badge bg-success"><button type="submit">Marquer comme lue</button></label>
                        </form>
                    </div>
                </li>
            @endforeach
            <hr class="dropdown-divider">
            @if(auth()->user()->unreadNotifications->count() > 0)
            <form action="{{ route('markAllAsRead') }}" method="POST">
              @csrf
              <label class="badge bg-warning"><button type="submit">Tout marquer comme lu</button></label>
            </form>
            @endif
          @endif
          
          @if(auth()->check() && auth()->user()->hasRole('Président'))
            @foreach(auth()->user()->unreadNotifications as $notification)
                <li class="notification-item">
                    <i class="bi bi-exclamation-circle text-warning"></i>
                    <div>
                        <h4>Nouveau Dossier</h4>
                        <p>{{ $notification->data['message'] }}</p>
                        <p>{{ $notification->created_at }}</p>
                        <form action="{{ route('markAsRead', ['notification' => $notification->id]) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('POST')
                            <label class="badge bg-success"><button type="submit">Marquer comme lue</button></label>
                        </form>
                    </div>
                </li>
            @endforeach
            <hr class="dropdown-divider">
            @if(auth()->user()->unreadNotifications->count() > 0)
            <form action="{{ route('markAllAsRead') }}" method="POST">
              @csrf
              <label class="badge bg-warning"><button type="submit">Tout marquer comme lu</button></label>
            </form>
            @endif
          @endif

          @if(auth()->check() && auth()->user()->hasRole('Juge'))
            @foreach(auth()->user()->unreadNotifications as $notification)
                <li class="notification-item">
                    <i class="bi bi-exclamation-circle text-warning"></i>
                    <div>
                        <h4>Nouveau Dossier</h4>
                        <p>{{ $notification->data['message'] }}</p>
                        <p>{{ $notification->created_at }}</p>
                        <form action="{{ route('markAsRead', ['notification' => $notification->id]) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('POST')
                            <label class="badge bg-success"><button type="submit">Marquer comme lue</button></label>
                        </form>
                    </div>
                </li>
            @endforeach
            <hr class="dropdown-divider">
            @if(auth()->user()->unreadNotifications->count() > 0)
            <form action="{{ route('markAllAsRead') }}" method="POST">
              @csrf
              <label class="badge bg-warning"><button type="submit">Tout marquer comme lu</button></label>
            </form>
            @endif
          @endif

          @if(auth()->check() && auth()->user()->hasRole('OMP'))
            @foreach(auth()->user()->unreadNotifications as $notification)
                <li class="notification-item">
                    <i class="bi bi-exclamation-circle text-warning"></i>
                    <div>
                        <h4>Nouveau Dossier</h4>
                        <p>{{ $notification->data['message'] }}</p>
                        <h3>{{ $notification->data['name'] }}</h3>
                        <p>{{ $notification->created_at }}</p>
                        <form action="{{ route('markAsRead', ['notification' => $notification->id]) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('POST')
                            <label class="badge bg-success"><button type="submit">Marquer comme lue</button></label>
                        </form>
                    </div>
                </li>
            @endforeach
            <hr class="dropdown-divider">
            @if(auth()->user()->unreadNotifications->count() > 0)
            <form action="{{ route('markAllAsRead') }}" method="POST">
              @csrf
              <label class="badge bg-warning"><button type="submit">Tout marquer comme lu</button></label>
            </form>
            @endif
          @endif

          @if(auth()->check() && auth()->user()->hasRole('Procureur'))
            @foreach(auth()->user()->unreadNotifications as $notification)
                <li class="notification-item">
                    <i class="bi bi-exclamation-circle text-warning"></i>
                    <div>
                        <h4>Nouveau Dossier</h4>
                        <p>{{ $notification->data['message'] }}</p>
                        <p>{{ $notification->created_at }}</p>
                        <form action="{{ route('markAsRead', ['notification' => $notification->id]) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('POST')
                            <label class="badge bg-success"><button type="submit">Marquer comme lue</button></label>
                        </form>
                    </div>
                </li>
            @endforeach
            <hr class="dropdown-divider">
            @if(auth()->user()->unreadNotifications->count() > 0)
            <form action="{{ route('markAllAsRead') }}" method="POST">
              @csrf
              <label class="badge bg-warning"><button type="submit">Tout marquer comme lu</button></label>
            </form>
            @endif
          @endif

          @if(auth()->check() && auth()->user()->hasRole('Secrétaire'))
            @foreach(auth()->user()->unreadNotifications as $notification)
                <li class="notification-item">
                    <i class="bi bi-exclamation-circle text-warning"></i>
                    <div>
                        <h4>Nouveau Dossier</h4>
                        <p>{{ $notification->data['message'] }}</p>
                        <p>{{ $notification->created_at }}</p>
                        <form action="{{ route('markAsRead', ['notification' => $notification->id]) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('POST')
                            <label class="badge bg-success"><button type="submit">Marquer comme lue</button></label>
                        </form>
                    </div>
                </li>
            @endforeach
            <hr class="dropdown-divider">
            @if(auth()->user()->unreadNotifications->count() > 0)
            <form action="{{ route('markAllAsRead') }}" method="POST">
              @csrf
              <label class="badge bg-warning"><button type="submit">Tout marquer comme lu</button></label>
            </form>
            @endif
          @endif
          

         

        </ul><!-- End Notification Dropdown Items -->

      </li>

        <li class="nav-item dropdown pe-3">

          <a class="nav-link nav-profile d-flex align-items-center pe-0" href="#" data-bs-toggle="dropdown">
            <img src="/assets/img/profile-img.jpg" alt="Profile" class="rounded-circle">
            <span class="d-none d-md-block dropdown-toggle ps-2">{{ Auth::user()->name }} {{ Auth::user()->lastname }}</span>
          </a><!-- End Profile Iamge Icon -->

          <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
            <li class="dropdown-header">
              <h6>{{ Auth::user()->name }} {{ Auth::user()->lastname }}</h6>
              <span>
                @if (!empty(Auth::user()->getRoleNames()))
                @foreach(Auth::user()->getRoleNames() as $rolename)
                <label class="badge bg-success mx-1">{{ $rolename }}</label>
                @endforeach
                @endif
              </span>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            <li>
              <a class="dropdown-item d-flex align-items-center" href="{{route('profile.edit')}}">
                <i class="bi bi-person"></i>
                <span>Mon Profile</span>
              </a>
            </li>
            <li>
              <hr class="dropdown-divider">
            </li>

            

            <form method="POST" action="{{ route('logout') }}">
                    @csrf

            <li>
              <a class="dropdown-item d-flex align-items-center" href="route('logout')" onclick="event.preventDefault(); this.closest('form').submit();">
                <i class="bi bi-box-arrow-right"></i>
                

                    
                
                <span>Déconnexion</span>
              </a>
            </li>

            </form>

          </ul><!-- End Profile Dropdown Items -->
        </li><!-- End Profile Nav -->

      </ul>
    </nav><!-- End Icons Navigation -->

  </header>

