<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\JuridictionParque;
use Illuminate\Database\QueryException;
use Illuminate\Validation\ValidationException;

class ParquetController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:View parquet', ['only' => ['index']]);
        $this->middleware('permission:Create parquet', ['only' => ['create', 'store']]);
        $this->middleware('permission:Update parquet', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Delete parquet', ['only' => ['destroy']]);
    }

    public function index(Request $request)
    {
        $parquets = JuridictionParque::where('nom', '=', 'parquet')
        ->when(
            $request->search,
            function (Builder $builder) use ($request) {
                $builder->where('nom', 'like', "%{$request->search}%");
            }
        )
        ->paginate(10);

        return view('parquet.index', compact('parquets'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $provinces = JuridictionParque::$provinces;

        return view('parquet.create', compact('provinces'));
    }

    
    public function store(Request $request)
    {
        $data = $request->validate([
            'nom' => 'required',
            'province' => 'required',
            'commune' => 'required',
        ]);

        JuridictionParque::create($data);;


        return redirect()->route('parquets.index')->with('success', "Parquet Successfully Created");
    }

    public function edit(JuridictionParque $parquet)
    {
        $provinces = JuridictionParque::$provinces;

        return view('parquet.edit', compact('parquet','provinces'));
    }

    public function update(Request $request,JuridictionParque $parquet)
    {
        $data = $request->validate([
            'nom' => 'required',
            'province' => 'required',
            'commune' => 'required',
        ]);


        $parquet->update([
            'nom' => $data['nom'],
            'province' => $data['province'],
            'commune' => $data['commune'],
        ]);

        return redirect()->route('parquets.index')->with('success', "Parquet updated successfully");
    }

    public function destroy(JuridictionParque $parquet)
    {
        try {
            $parquet->delete();
    
            return redirect()->route('parquets.index')->with('success', 'Parquet deleted successful');
        } catch (QueryException $e) {
            $errors = [
                'delete_error' => 'Impossible de supprimer cette Parquet'
            ];
    
            throw ValidationException::withMessages($errors);
        }

        
    }
}
