<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Institution;
use App\Models\User;
use Spatie\Permission\Models\Role;

class InstitutionController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:Voir institution', ['only' => ['index']]);
        $this->middleware('permission:Créer institution', ['only' => ['create', 'store']]);
        $this->middleware('permission:Modifier institution', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Supprimer institution', ['only' => ['destroy']]);
    }

    public function index()
    {
        $institutions = Institution::all();

        return view('institutions.index', compact('institutions'));
    }

    
    public function create()
    {
        
        return view('institutions.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'nom' => 'required',
            'email' => 'required',
            'password' => 'required',
        ]);

        Institution::create($data);

        $nuser = new User();
        $nuser->name = $request->nom;
        $nuser->lastname = $request->nom;
        $nuser->email = $request->email;
        $nuser->password = bcrypt($request->password);
        $nuser->save();

        $nuser = User::where('email', $request->email)->first();

        $adminRole = Role::where('name', 'Admin')->first();
        $nuser->syncRoles([$adminRole->id]);


        return redirect()->route('institutions.index')->with('success', "Vous avez crée l'institution");
    }

    public function edit(Institution $institution)
    {
       

        return view('institutions.edit', compact('institution'));
    }

    public function update(Request $request,Institution $institution)
    {
        $data = $request->validate([
            'nom' => 'required',
        ]);


        $institution->update([
            'nom' => $data['nom'],
        ]);

        $nuser = new User();
        $nuser->name = $request->nom;
        $nuser->update();

        

        return redirect()->route('institutions.index')->with('success', "Vous avez modifié l'institution");
    }

    public function destroy($institutionId)
    {
        $institution = Institution::find($institutionId);
        $institution->delete();

        return redirect()->route('institutions.index')->with('success', 'Vous avez supprimé l\'institution');
    }
}
