<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Employe;
use App\Models\User;
use App\Models\Type_employe;
use Illuminate\Support\Facades\Auth;

class EmployeController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:Voir employe', ['only' => ['index']]);
        $this->middleware('permission:Créer employe', ['only' => ['create', 'store']]);
        $this->middleware('permission:Modifier employe', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Supprimer employe', ['only' => ['destroy']]);
    }

    public function index()
    {
        $admin = Auth::user();
        $employes = Employe::where('user_id', $admin->id)->get();

        return view('employes.index', compact('employes'));
    }

    
    public function create()
    {
        $type = Type_employe::all();
        return view('employes.create', compact('type'));
    }

    public function store(Request $request)
    {
        $admin = Auth::user();

        $employe = new Employe();
        $employe->nom = $request->nom;
        $employe->prenom = $request->prenom;
        $employe->sexe = $request->sexe;
        $employe->user_id = $admin->id;
        $employe->type_employe_id = $request->type_employe_id;
        $employe->save();


        return redirect()->route('employes.index')->with('success', "Vous avez crée l'employe");
    }

    public function edit(Employe $employe)
    {
        $type = Type_employe::all();

        return view('employes.edit', compact('employe', 'type'));
    }

    public function update(Request $request,Employe $employe)
    {
        $employe->nom = $request->nom;
        $employe->prenom = $request->prenom;
        $employe->sexe = $request->sexe;
        $employe->type_employe_id = $request->type_employe_id;
        $employe->update();

        return redirect()->route('employes.index')->with('success', "Vous avez modifié l'employe");
    }

    public function destroy($employeId)
    {
        $employe = Employe::find($employeId);
        $employe->delete();

        return redirect()->route('employes.index')->with('success', 'Vous avez supprimé l\'employe');
    }
}
