<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Beneficiaire;
use App\Models\Region;
use App\Models\Categorie_professionnelle;
use App\Models\Secteur_activite;
use App\Models\Commune;
use App\Models\Colline;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\QueryException;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Models\Role;

class BeneficiaireController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:Voir bénéficiaire', ['only' => ['index']]);
        $this->middleware('permission:Créer bénéficiaire', ['only' => ['create', 'store']]);
        $this->middleware('permission:Modifier bénéficiaire', ['only' => ['edit', 'update']]);
        $this->middleware('permission:Supprimer bénéficiaire', ['only' => ['destroy']]);
    }

    public function index()
    {
        $admin = Auth::user();

        $beneficiaires = Beneficiaire::where('user_id', $admin->id)->get();

        return view('beneficiaires.index', compact('beneficiaires'));
    }

    
    public function create()
    {
        $regions = Region::all();
        $secteurs = Secteur_activite::all();
        $categories = Categorie_professionnelle::all();
        return view('beneficiaires.create', compact('regions', 'secteurs', 'categories'));
    }

    public function store(Request $request)
    {
        $admin = Auth::user();

        $beneficiaire = new Beneficiaire();
        $beneficiaire->nom = $request->nom;
        $beneficiaire->prenom = $request->prenom;
        $beneficiaire->email = $request->email;
        $beneficiaire->telephone = $request->telephone;
        $beneficiaire->age = $request->age;
        $beneficiaire->sexe = $request->sexe;
        $beneficiaire->projet = $request->projet;
        $beneficiaire->montant = $request->montant;
        $beneficiaire->colline_id = $request->colline_id;
        $beneficiaire->secteur_id = $request->secteur_id;
        $beneficiaire->categorie_id = $request->categorie_id;
        $beneficiaire->user_id = $admin->id;
        $beneficiaire->password = Hash::make($request->password);
        $beneficiaire->save();

        $nuser = new User();
        $nuser->name = $request->nom;
        $nuser->lastname = $request->prenom;
        $nuser->email = $request->email;
        $nuser->password = Hash::make($request->password);
        $nuser->save();

        $nuser = User::where('email', $request->email)->first();

        $adminRole = Role::where('name', 'Bénéficiaire')->first();
        $nuser->syncRoles([$adminRole->id]);


        return redirect()->route('beneficiaires.index')->with('success', "Vous avez crée une bénéficiaire");
    }

    public function edit(Beneficiaire $beneficiaire)
    {
        $regions = Region::all();
        $secteurs = Secteur_activite::all();
        $categories = Categorie_professionnelle::all();

        return view('beneficiaires.edit', compact('beneficiaire', 'regions', 'secteurs', 'categories'));
    }

    public function update(Request $request,Beneficiaire $beneficiaire)
    {
        
        $beneficiaire->telephone = $request->telephone;
        $beneficiaire->age = $request->age;
        $beneficiaire->sexe = $request->sexe;
        $beneficiaire->projet = $request->projet;
        $beneficiaire->montant = $request->montant;
        $beneficiaire->colline_id = $request->colline_id;
        $beneficiaire->secteur_id = $request->secteur_id;
        $beneficiaire->categorie_id = $request->categorie_id;
        $beneficiaire->update();

        return redirect()->route('beneficiaires.index')->with('success', "Vous avez modifié une bénéficiaire");
    }

    public function destroy($beneficiaireId)
    {
        $beneficiaire = Beneficiaire::find($beneficiaireId);
        $beneficiaire->delete();

        return redirect()->route('beneficiaires.index')->with('success', 'Vous avez supprimé la colline');
    }
}
